// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.HealthEventStatus
import aws.sdk.kotlin.services.internetmonitor.model.ListHealthEventsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListHealthEventsOperationSerializer: HttpSerialize<ListHealthEventsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListHealthEventsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("v20210603"))
                add(PercentEncoding.Path.encode("Monitors"))
                add(PercentEncoding.SmithyLabel.encode("${input.monitorName}"))
                add(PercentEncoding.Path.encode("HealthEvents"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.endTime != null) add("EndTime", input.endTime.format(TimestampFormat.ISO_8601))
                if (input.eventStatus != null) add("EventStatus", input.eventStatus.value)
                if (input.maxResults != null) add("MaxResults", "${input.maxResults}")
                if (input.nextToken != null) add("NextToken", input.nextToken)
                if (input.startTime != null) add("StartTime", input.startTime.format(TimestampFormat.ISO_8601))
            }
        }

        return builder
    }
}
