// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.GetQueryResultsResponse
import aws.sdk.kotlin.services.internetmonitor.model.InternetMonitorException
import aws.sdk.kotlin.services.internetmonitor.model.QueryField
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetQueryResultsOperationDeserializer: HttpDeserialize<GetQueryResultsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetQueryResultsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetQueryResultsError(context, call)
        }
        val builder = GetQueryResultsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetQueryResultsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetQueryResultsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InternetMonitorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> InternetMonitorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetQueryResultsOperationBody(builder: GetQueryResultsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Data"))
    val DATA_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val FIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Fields"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATA_DESCRIPTOR)
        field(FIELDS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATA_DESCRIPTOR.index -> builder.data =
                    deserializer.deserializeList(DATA_DESCRIPTOR) {
                        val col0 = mutableListOf<List<String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(DATA_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<String>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                FIELDS_DESCRIPTOR.index -> builder.fields =
                    deserializer.deserializeList(FIELDS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryField>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryFieldDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
