// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.GetMonitorResponse
import aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig
import aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery
import aws.sdk.kotlin.services.internetmonitor.model.InternetMonitorException
import aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState
import aws.sdk.kotlin.services.internetmonitor.model.MonitorProcessingStatusCode
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetMonitorOperationDeserializer: HttpDeserialize<GetMonitorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetMonitorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMonitorError(context, call)
        }
        val builder = GetMonitorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMonitorOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetMonitorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InternetMonitorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> InternetMonitorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMonitorOperationBody(builder: GetMonitorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedAt"))
    val HEALTHEVENTSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HealthEventsConfig"))
    val INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("InternetMeasurementsLogDelivery"))
    val MAXCITYNETWORKSTOMONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxCityNetworksToMonitor"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ModifiedAt"))
    val MONITORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitorArn"))
    val MONITORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MonitorName"))
    val PROCESSINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProcessingStatus"))
    val PROCESSINGSTATUSINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProcessingStatusInfo"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Resources"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TrafficPercentageToMonitor"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATEDAT_DESCRIPTOR)
        field(HEALTHEVENTSCONFIG_DESCRIPTOR)
        field(INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR)
        field(MAXCITYNETWORKSTOMONITOR_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(MONITORARN_DESCRIPTOR)
        field(MONITORNAME_DESCRIPTOR)
        field(PROCESSINGSTATUS_DESCRIPTOR)
        field(PROCESSINGSTATUSINFO_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromIso8601(it) }
                HEALTHEVENTSCONFIG_DESCRIPTOR.index -> builder.healthEventsConfig = deserializeHealthEventsConfigDocument(deserializer)
                INTERNETMEASUREMENTSLOGDELIVERY_DESCRIPTOR.index -> builder.internetMeasurementsLogDelivery = deserializeInternetMeasurementsLogDeliveryDocument(deserializer)
                MAXCITYNETWORKSTOMONITOR_DESCRIPTOR.index -> builder.maxCityNetworksToMonitor = deserializeInt()
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeString().let { Instant.fromIso8601(it) }
                MONITORARN_DESCRIPTOR.index -> builder.monitorArn = deserializeString()
                MONITORNAME_DESCRIPTOR.index -> builder.monitorName = deserializeString()
                PROCESSINGSTATUS_DESCRIPTOR.index -> builder.processingStatus = deserializeString().let { MonitorProcessingStatusCode.fromValue(it) }
                PROCESSINGSTATUSINFO_DESCRIPTOR.index -> builder.processingStatusInfo = deserializeString()
                RESOURCES_DESCRIPTOR.index -> builder.resources =
                    deserializer.deserializeList(RESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MonitorConfigState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TRAFFICPERCENTAGETOMONITOR_DESCRIPTOR.index -> builder.trafficPercentageToMonitor = deserializeInt()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
