// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.serde

import aws.sdk.kotlin.services.internetmonitor.model.DeleteMonitorResponse
import aws.sdk.kotlin.services.internetmonitor.model.InternetMonitorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class DeleteMonitorOperationDeserializer: HttpDeserialize<DeleteMonitorResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteMonitorResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteMonitorError(context, call)
        }
        val builder = DeleteMonitorResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteMonitorError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw InternetMonitorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> InternetMonitorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
