// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



public class UpdateMonitorRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The list of health score thresholds. A threshold percentage for health scores, along with other configuration information, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users.
     *
     * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val healthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig? = builder.healthEventsConfig
    /**
     * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.
     */
    public val internetMeasurementsLogDelivery: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery? = builder.internetMeasurementsLogDelivery
    /**
     * The maximum number of city-networks to monitor for your application. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. Setting this limit can help control billing costs.
     */
    public val maxCityNetworksToMonitor: kotlin.Int? = builder.maxCityNetworksToMonitor
    /**
     * The name of the monitor.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon CloudFront distributions, or Amazon WorkSpaces directories.
     *
     * You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can't add NLBs or WorkSpaces directories together with any other resources.
     *
     * If you add only Amazon Virtual Private Clouds resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.
     */
    public val resourcesToAdd: List<String>? = builder.resourcesToAdd
    /**
     * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
     */
    public val resourcesToRemove: List<String>? = builder.resourcesToRemove
    /**
     * The status for a monitor. The accepted values for `Status` with the `UpdateMonitor` API call are the following: `ACTIVE` and `INACTIVE`. The following values are *not* accepted: `PENDING`, and `ERROR`.
     */
    public val status: aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState? = builder.status
    /**
     * The percentage of the internet-facing traffic for your application that you want to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.
     *
     * To learn more, see [Choosing an application traffic percentage to monitor ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val trafficPercentageToMonitor: kotlin.Int? = builder.trafficPercentageToMonitor

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.UpdateMonitorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMonitorRequest(")
        append("clientToken=$clientToken,")
        append("healthEventsConfig=$healthEventsConfig,")
        append("internetMeasurementsLogDelivery=$internetMeasurementsLogDelivery,")
        append("maxCityNetworksToMonitor=$maxCityNetworksToMonitor,")
        append("monitorName=$monitorName,")
        append("resourcesToAdd=$resourcesToAdd,")
        append("resourcesToRemove=$resourcesToRemove,")
        append("status=$status,")
        append("trafficPercentageToMonitor=$trafficPercentageToMonitor")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (healthEventsConfig?.hashCode() ?: 0)
        result = 31 * result + (internetMeasurementsLogDelivery?.hashCode() ?: 0)
        result = 31 * result + (maxCityNetworksToMonitor ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (resourcesToAdd?.hashCode() ?: 0)
        result = 31 * result + (resourcesToRemove?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trafficPercentageToMonitor ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMonitorRequest

        if (clientToken != other.clientToken) return false
        if (healthEventsConfig != other.healthEventsConfig) return false
        if (internetMeasurementsLogDelivery != other.internetMeasurementsLogDelivery) return false
        if (maxCityNetworksToMonitor != other.maxCityNetworksToMonitor) return false
        if (monitorName != other.monitorName) return false
        if (resourcesToAdd != other.resourcesToAdd) return false
        if (resourcesToRemove != other.resourcesToRemove) return false
        if (status != other.status) return false
        if (trafficPercentageToMonitor != other.trafficPercentageToMonitor) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.UpdateMonitorRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The list of health score thresholds. A threshold percentage for health scores, along with other configuration information, determines when Internet Monitor creates a health event when there's an internet issue that affects your application end users.
         *
         * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var healthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig? = null
        /**
         * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.
         */
        public var internetMeasurementsLogDelivery: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery? = null
        /**
         * The maximum number of city-networks to monitor for your application. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. Setting this limit can help control billing costs.
         */
        public var maxCityNetworksToMonitor: kotlin.Int? = null
        /**
         * The name of the monitor.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon CloudFront distributions, or Amazon WorkSpaces directories.
         *
         * You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can't add NLBs or WorkSpaces directories together with any other resources.
         *
         * If you add only Amazon Virtual Private Clouds resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.
         */
        public var resourcesToAdd: List<String>? = null
        /**
         * The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).
         */
        public var resourcesToRemove: List<String>? = null
        /**
         * The status for a monitor. The accepted values for `Status` with the `UpdateMonitor` API call are the following: `ACTIVE` and `INACTIVE`. The following values are *not* accepted: `PENDING`, and `ERROR`.
         */
        public var status: aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState? = null
        /**
         * The percentage of the internet-facing traffic for your application that you want to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.
         *
         * To learn more, see [Choosing an application traffic percentage to monitor ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var trafficPercentageToMonitor: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.UpdateMonitorRequest) : this() {
            this.clientToken = x.clientToken
            this.healthEventsConfig = x.healthEventsConfig
            this.internetMeasurementsLogDelivery = x.internetMeasurementsLogDelivery
            this.maxCityNetworksToMonitor = x.maxCityNetworksToMonitor
            this.monitorName = x.monitorName
            this.resourcesToAdd = x.resourcesToAdd
            this.resourcesToRemove = x.resourcesToRemove
            this.status = x.status
            this.trafficPercentageToMonitor = x.trafficPercentageToMonitor
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.UpdateMonitorRequest = UpdateMonitorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig] inside the given [block]
         */
        public fun healthEventsConfig(block: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig.Builder.() -> kotlin.Unit) {
            this.healthEventsConfig = aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery] inside the given [block]
         */
        public fun internetMeasurementsLogDelivery(block: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery.Builder.() -> kotlin.Unit) {
            this.internetMeasurementsLogDelivery = aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
