// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model

import aws.smithy.kotlin.runtime.time.Instant

public class StartQueryRequest private constructor(builder: Builder) {
    /**
     * The timestamp that is the end of the period that you want to retrieve data for with your query.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The `FilterParameters` field that you use with Amazon CloudWatch Internet Monitor queries is a string the defines how you want a query to be filtered. The filter parameters that you can specify depend on the query type, since each query type returns a different set of Internet Monitor data.
     *
     * For more information about specifying filter parameters, see [Using the Amazon CloudWatch Internet Monitor query interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html) in the Amazon CloudWatch Internet Monitor User Guide.
     */
    public val filterParameters: List<FilterParameter>? = builder.filterParameters
    /**
     * The name of the monitor to query.
     */
    public val monitorName: kotlin.String? = builder.monitorName
    /**
     * The type of query to run. The following are the three types of queries that you can run using the Internet Monitor query interface:
     * + `MEASUREMENTS`: Provides availability score, performance score, total traffic, and round-trip times, at 5 minute intervals.
     * + `TOP_LOCATIONS`: Provides availability score, performance score, total traffic, and time to first byte (TTFB) information, for the top location and ASN combinations that you're monitoring, by traffic volume.
     * + `TOP_LOCATION_DETAILS`: Provides TTFB for Amazon CloudFront, your current configuration, and the best performing EC2 configuration, at 1 hour intervals.
     *
     * For lists of the fields returned with each query type and more information about how each type of query is performed, see [ Using the Amazon CloudWatch Internet Monitor query interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html) in the Amazon CloudWatch Internet Monitor User Guide.
     */
    public val queryType: aws.sdk.kotlin.services.internetmonitor.model.QueryType? = builder.queryType
    /**
     * The timestamp that is the beginning of the period that you want to retrieve data for with your query.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.StartQueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartQueryRequest(")
        append("endTime=$endTime,")
        append("filterParameters=$filterParameters,")
        append("monitorName=$monitorName,")
        append("queryType=$queryType,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (filterParameters?.hashCode() ?: 0)
        result = 31 * result + (monitorName?.hashCode() ?: 0)
        result = 31 * result + (queryType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartQueryRequest

        if (endTime != other.endTime) return false
        if (filterParameters != other.filterParameters) return false
        if (monitorName != other.monitorName) return false
        if (queryType != other.queryType) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.StartQueryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp that is the end of the period that you want to retrieve data for with your query.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The `FilterParameters` field that you use with Amazon CloudWatch Internet Monitor queries is a string the defines how you want a query to be filtered. The filter parameters that you can specify depend on the query type, since each query type returns a different set of Internet Monitor data.
         *
         * For more information about specifying filter parameters, see [Using the Amazon CloudWatch Internet Monitor query interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html) in the Amazon CloudWatch Internet Monitor User Guide.
         */
        public var filterParameters: List<FilterParameter>? = null
        /**
         * The name of the monitor to query.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The type of query to run. The following are the three types of queries that you can run using the Internet Monitor query interface:
         * + `MEASUREMENTS`: Provides availability score, performance score, total traffic, and round-trip times, at 5 minute intervals.
         * + `TOP_LOCATIONS`: Provides availability score, performance score, total traffic, and time to first byte (TTFB) information, for the top location and ASN combinations that you're monitoring, by traffic volume.
         * + `TOP_LOCATION_DETAILS`: Provides TTFB for Amazon CloudFront, your current configuration, and the best performing EC2 configuration, at 1 hour intervals.
         *
         * For lists of the fields returned with each query type and more information about how each type of query is performed, see [ Using the Amazon CloudWatch Internet Monitor query interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html) in the Amazon CloudWatch Internet Monitor User Guide.
         */
        public var queryType: aws.sdk.kotlin.services.internetmonitor.model.QueryType? = null
        /**
         * The timestamp that is the beginning of the period that you want to retrieve data for with your query.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.StartQueryRequest) : this() {
            this.endTime = x.endTime
            this.filterParameters = x.filterParameters
            this.monitorName = x.monitorName
            this.queryType = x.queryType
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.StartQueryRequest = StartQueryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
