// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance or availability issue, when scores cross a threshold for one or more city-networks.
 *
 * Defines the percentages, for performance scores or availability scores, that are the local thresholds for when Amazon CloudWatch Internet Monitor creates a health event. Also defines whether a local threshold is enabled or disabled, and the minimum percentage of overall traffic that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
 *
 * If you don't set a local health event threshold, the default value is 60%.
 *
 * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
 */
public class LocalHealthEventsConfig private constructor(builder: Builder) {
    /**
     * The health event threshold percentage set for a local health score.
     */
    public val healthScoreThreshold: kotlin.Double = builder.healthScoreThreshold
    /**
     * The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
     *
     * If you don't set a minimum traffic impact threshold, the default value is 0.1%.
     */
    public val minTrafficImpact: kotlin.Double = builder.minTrafficImpact
    /**
     * The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be `ENABLED` or `DISABLED`.
     */
    public val status: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfigStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocalHealthEventsConfig(")
        append("healthScoreThreshold=$healthScoreThreshold,")
        append("minTrafficImpact=$minTrafficImpact,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthScoreThreshold.hashCode()
        result = 31 * result + (minTrafficImpact.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocalHealthEventsConfig

        if (healthScoreThreshold != other.healthScoreThreshold) return false
        if (minTrafficImpact != other.minTrafficImpact) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The health event threshold percentage set for a local health score.
         */
        public var healthScoreThreshold: kotlin.Double = 0.0
        /**
         * The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.
         *
         * If you don't set a minimum traffic impact threshold, the default value is 0.1%.
         */
        public var minTrafficImpact: kotlin.Double = 0.0
        /**
         * The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be `ENABLED` or `DISABLED`.
         */
        public var status: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfigStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig) : this() {
            this.healthScoreThreshold = x.healthScoreThreshold
            this.minTrafficImpact = x.minTrafficImpact
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig = LocalHealthEventsConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
