// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * Internet health includes measurements calculated by Amazon CloudWatch Internet Monitor about the performance and availability for your application on the internet. Amazon Web Services has substantial historical data about internet performance and availability between Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to an estimated baseline that's already calculated. To make it easier to see those drops, Internet Monitor reports the information to you in the form of health scores: a performance score and an availability score.
 */
public class InternetHealth private constructor(builder: Builder) {
    /**
     * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing an availability drop for that pair.
     *
     * For more information, see [How Internet Monitor calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val availability: aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement? = builder.availability
    /**
     * Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a performance drop. For example, a performance score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing a performance drop for that pair.
     *
     * For more information, see [How Internet Monitor calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val performance: aws.sdk.kotlin.services.internetmonitor.model.PerformanceMeasurement? = builder.performance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.InternetHealth = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InternetHealth(")
        append("availability=$availability,")
        append("performance=$performance")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availability?.hashCode() ?: 0
        result = 31 * result + (performance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InternetHealth

        if (availability != other.availability) return false
        if (performance != other.performance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.InternetHealth = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing an availability drop for that pair.
         *
         * For more information, see [How Internet Monitor calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var availability: aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement? = null
        /**
         * Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a performance drop. For example, a performance score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing a performance drop for that pair.
         *
         * For more information, see [How Internet Monitor calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var performance: aws.sdk.kotlin.services.internetmonitor.model.PerformanceMeasurement? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.InternetHealth) : this() {
            this.availability = x.availability
            this.performance = x.performance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.InternetHealth = InternetHealth(this)

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement] inside the given [block]
         */
        public fun availability(block: aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement.Builder.() -> kotlin.Unit) {
            this.availability = aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.PerformanceMeasurement] inside the given [block]
         */
        public fun performance(block: aws.sdk.kotlin.services.internetmonitor.model.PerformanceMeasurement.Builder.() -> kotlin.Unit) {
            this.performance = aws.sdk.kotlin.services.internetmonitor.model.PerformanceMeasurement.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
