// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * Information about a location impacted by a health event in Amazon CloudWatch Internet Monitor.
 *
 * Geographic regions are hierarchically categorized into country, subdivision, metro and city geographic granularities. The geographic region is identified based on the IP address used at the client locations.
 */
public class ImpactedLocation private constructor(builder: Builder) {
    /**
     * The name of the network at an impacted location.
     */
    public val asName: kotlin.String = requireNotNull(builder.asName) { "A non-null value must be provided for asName" }
    /**
     * The Autonomous System Number (ASN) of the network at an impacted location.
     */
    public val asNumber: kotlin.Long = requireNotNull(builder.asNumber) { "A non-null value must be provided for asNumber" }
    /**
     * The cause of the impairment. There are two types of network impairments: Amazon Web Services network issues or internet issues. Internet issues are typically a problem with a network provider, like an internet service provider (ISP).
     */
    public val causedBy: aws.sdk.kotlin.services.internetmonitor.model.NetworkImpairment? = builder.causedBy
    /**
     * The name of the city where the health event is located.
     */
    public val city: kotlin.String? = builder.city
    /**
     * The name of the country where the health event is located.
     */
    public val country: kotlin.String = requireNotNull(builder.country) { "A non-null value must be provided for country" }
    /**
     * The country code where the health event is located. The ISO 3166-2 codes for the country is provided, when available.
     */
    public val countryCode: kotlin.String? = builder.countryCode
    /**
     * The calculated health at a specific location.
     */
    public val internetHealth: aws.sdk.kotlin.services.internetmonitor.model.InternetHealth? = builder.internetHealth
    /**
     * The IPv4 prefixes at the client location that was impacted by the health event.
     */
    public val ipv4Prefixes: List<String>? = builder.ipv4Prefixes
    /**
     * The latitude where the health event is located.
     */
    public val latitude: kotlin.Double? = builder.latitude
    /**
     * The longitude where the health event is located.
     */
    public val longitude: kotlin.Double? = builder.longitude
    /**
     * The metro area where the health event is located.
     *
     * Metro indicates a metropolitan region in the United States, such as the region around New York City. In non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a county, a London borough, a unitary authority, council area, and so on.
     */
    public val metro: kotlin.String? = builder.metro
    /**
     * The service location where the health event is located.
     */
    public val serviceLocation: kotlin.String? = builder.serviceLocation
    /**
     * The status of the health event at an impacted location.
     */
    public val status: aws.sdk.kotlin.services.internetmonitor.model.HealthEventStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The subdivision location where the health event is located. The subdivision usually maps to states in most countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales) or province (Northern Ireland).
     */
    public val subdivision: kotlin.String? = builder.subdivision
    /**
     * The subdivision code where the health event is located. The ISO 3166-2 codes for country subdivisions is provided, when available.
     */
    public val subdivisionCode: kotlin.String? = builder.subdivisionCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.ImpactedLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImpactedLocation(")
        append("asName=$asName,")
        append("asNumber=$asNumber,")
        append("causedBy=$causedBy,")
        append("city=$city,")
        append("country=$country,")
        append("countryCode=$countryCode,")
        append("internetHealth=$internetHealth,")
        append("ipv4Prefixes=$ipv4Prefixes,")
        append("latitude=$latitude,")
        append("longitude=$longitude,")
        append("metro=$metro,")
        append("serviceLocation=$serviceLocation,")
        append("status=$status,")
        append("subdivision=$subdivision,")
        append("subdivisionCode=$subdivisionCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = asName.hashCode()
        result = 31 * result + (asNumber.hashCode())
        result = 31 * result + (causedBy?.hashCode() ?: 0)
        result = 31 * result + (city?.hashCode() ?: 0)
        result = 31 * result + (country.hashCode())
        result = 31 * result + (countryCode?.hashCode() ?: 0)
        result = 31 * result + (internetHealth?.hashCode() ?: 0)
        result = 31 * result + (ipv4Prefixes?.hashCode() ?: 0)
        result = 31 * result + (latitude?.hashCode() ?: 0)
        result = 31 * result + (longitude?.hashCode() ?: 0)
        result = 31 * result + (metro?.hashCode() ?: 0)
        result = 31 * result + (serviceLocation?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (subdivision?.hashCode() ?: 0)
        result = 31 * result + (subdivisionCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImpactedLocation

        if (asName != other.asName) return false
        if (asNumber != other.asNumber) return false
        if (causedBy != other.causedBy) return false
        if (city != other.city) return false
        if (country != other.country) return false
        if (countryCode != other.countryCode) return false
        if (internetHealth != other.internetHealth) return false
        if (ipv4Prefixes != other.ipv4Prefixes) return false
        if (latitude != other.latitude) return false
        if (longitude != other.longitude) return false
        if (metro != other.metro) return false
        if (serviceLocation != other.serviceLocation) return false
        if (status != other.status) return false
        if (subdivision != other.subdivision) return false
        if (subdivisionCode != other.subdivisionCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.ImpactedLocation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the network at an impacted location.
         */
        public var asName: kotlin.String? = null
        /**
         * The Autonomous System Number (ASN) of the network at an impacted location.
         */
        public var asNumber: kotlin.Long? = null
        /**
         * The cause of the impairment. There are two types of network impairments: Amazon Web Services network issues or internet issues. Internet issues are typically a problem with a network provider, like an internet service provider (ISP).
         */
        public var causedBy: aws.sdk.kotlin.services.internetmonitor.model.NetworkImpairment? = null
        /**
         * The name of the city where the health event is located.
         */
        public var city: kotlin.String? = null
        /**
         * The name of the country where the health event is located.
         */
        public var country: kotlin.String? = null
        /**
         * The country code where the health event is located. The ISO 3166-2 codes for the country is provided, when available.
         */
        public var countryCode: kotlin.String? = null
        /**
         * The calculated health at a specific location.
         */
        public var internetHealth: aws.sdk.kotlin.services.internetmonitor.model.InternetHealth? = null
        /**
         * The IPv4 prefixes at the client location that was impacted by the health event.
         */
        public var ipv4Prefixes: List<String>? = null
        /**
         * The latitude where the health event is located.
         */
        public var latitude: kotlin.Double? = null
        /**
         * The longitude where the health event is located.
         */
        public var longitude: kotlin.Double? = null
        /**
         * The metro area where the health event is located.
         *
         * Metro indicates a metropolitan region in the United States, such as the region around New York City. In non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a county, a London borough, a unitary authority, council area, and so on.
         */
        public var metro: kotlin.String? = null
        /**
         * The service location where the health event is located.
         */
        public var serviceLocation: kotlin.String? = null
        /**
         * The status of the health event at an impacted location.
         */
        public var status: aws.sdk.kotlin.services.internetmonitor.model.HealthEventStatus? = null
        /**
         * The subdivision location where the health event is located. The subdivision usually maps to states in most countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales) or province (Northern Ireland).
         */
        public var subdivision: kotlin.String? = null
        /**
         * The subdivision code where the health event is located. The ISO 3166-2 codes for country subdivisions is provided, when available.
         */
        public var subdivisionCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.ImpactedLocation) : this() {
            this.asName = x.asName
            this.asNumber = x.asNumber
            this.causedBy = x.causedBy
            this.city = x.city
            this.country = x.country
            this.countryCode = x.countryCode
            this.internetHealth = x.internetHealth
            this.ipv4Prefixes = x.ipv4Prefixes
            this.latitude = x.latitude
            this.longitude = x.longitude
            this.metro = x.metro
            this.serviceLocation = x.serviceLocation
            this.status = x.status
            this.subdivision = x.subdivision
            this.subdivisionCode = x.subdivisionCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.ImpactedLocation = ImpactedLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.NetworkImpairment] inside the given [block]
         */
        public fun causedBy(block: aws.sdk.kotlin.services.internetmonitor.model.NetworkImpairment.Builder.() -> kotlin.Unit) {
            this.causedBy = aws.sdk.kotlin.services.internetmonitor.model.NetworkImpairment.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.InternetHealth] inside the given [block]
         */
        public fun internetHealth(block: aws.sdk.kotlin.services.internetmonitor.model.InternetHealth.Builder.() -> kotlin.Unit) {
            this.internetHealth = aws.sdk.kotlin.services.internetmonitor.model.InternetHealth.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (asName == null) asName = ""
            if (asNumber == null) asNumber = 0L
            if (country == null) country = ""
            if (status == null) status = HealthEventStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
