// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application's geographies.
 *
 * Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Amazon CloudWatch Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.
 *
 * You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.
 *
 * If you don't set a health event threshold, the default value is 95%.
 *
 * For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.
 *
 * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
 */
public class HealthEventsConfig private constructor(builder: Builder) {
    /**
     * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
     */
    public val availabilityLocalHealthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig? = builder.availabilityLocalHealthEventsConfig
    /**
     * The health event threshold percentage set for availability scores.
     */
    public val availabilityScoreThreshold: kotlin.Double = builder.availabilityScoreThreshold
    /**
     * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
     */
    public val performanceLocalHealthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig? = builder.performanceLocalHealthEventsConfig
    /**
     * The health event threshold percentage set for performance scores.
     */
    public val performanceScoreThreshold: kotlin.Double = builder.performanceScoreThreshold

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthEventsConfig(")
        append("availabilityLocalHealthEventsConfig=$availabilityLocalHealthEventsConfig,")
        append("availabilityScoreThreshold=$availabilityScoreThreshold,")
        append("performanceLocalHealthEventsConfig=$performanceLocalHealthEventsConfig,")
        append("performanceScoreThreshold=$performanceScoreThreshold")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityLocalHealthEventsConfig?.hashCode() ?: 0
        result = 31 * result + (availabilityScoreThreshold.hashCode())
        result = 31 * result + (performanceLocalHealthEventsConfig?.hashCode() ?: 0)
        result = 31 * result + (performanceScoreThreshold.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthEventsConfig

        if (availabilityLocalHealthEventsConfig != other.availabilityLocalHealthEventsConfig) return false
        if (availabilityScoreThreshold != other.availabilityScoreThreshold) return false
        if (performanceLocalHealthEventsConfig != other.performanceLocalHealthEventsConfig) return false
        if (performanceScoreThreshold != other.performanceScoreThreshold) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.
         */
        public var availabilityLocalHealthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig? = null
        /**
         * The health event threshold percentage set for availability scores.
         */
        public var availabilityScoreThreshold: kotlin.Double = 0.0
        /**
         * The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.
         */
        public var performanceLocalHealthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig? = null
        /**
         * The health event threshold percentage set for performance scores.
         */
        public var performanceScoreThreshold: kotlin.Double = 0.0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig) : this() {
            this.availabilityLocalHealthEventsConfig = x.availabilityLocalHealthEventsConfig
            this.availabilityScoreThreshold = x.availabilityScoreThreshold
            this.performanceLocalHealthEventsConfig = x.performanceLocalHealthEventsConfig
            this.performanceScoreThreshold = x.performanceScoreThreshold
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig = HealthEventsConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig] inside the given [block]
         */
        public fun availabilityLocalHealthEventsConfig(block: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig.Builder.() -> kotlin.Unit) {
            this.availabilityLocalHealthEventsConfig = aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig] inside the given [block]
         */
        public fun performanceLocalHealthEventsConfig(block: aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig.Builder.() -> kotlin.Unit) {
            this.performanceLocalHealthEventsConfig = aws.sdk.kotlin.services.internetmonitor.model.LocalHealthEventsConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
