// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a health event created in a monitor in Amazon CloudWatch Internet Monitor.
 */
public class HealthEvent private constructor(builder: Builder) {
    /**
     * When the health event was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The time when a health event ended. If the health event is still active, then the end time is not set.
     */
    public val endedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.endedAt
    /**
     * The Amazon Resource Name (ARN) of the event.
     */
    public val eventArn: kotlin.String = requireNotNull(builder.eventArn) { "A non-null value must be provided for eventArn" }
    /**
     * The internally-generated identifier of a specific network traffic impairment health event.
     */
    public val eventId: kotlin.String = requireNotNull(builder.eventId) { "A non-null value must be provided for eventId" }
    /**
     * The value of the threshold percentage for performance or availability that was configured when Amazon CloudWatch Internet Monitor created the health event.
     */
    public val healthScoreThreshold: kotlin.Double = builder.healthScoreThreshold
    /**
     * The type of impairment for a health event.
     */
    public val impactType: aws.sdk.kotlin.services.internetmonitor.model.HealthEventImpactType = requireNotNull(builder.impactType) { "A non-null value must be provided for impactType" }
    /**
     * The locations impacted by the health event.
     */
    public val impactedLocations: List<ImpactedLocation> = requireNotNull(builder.impactedLocations) { "A non-null value must be provided for impactedLocations" }
    /**
     * When the health event was last updated.
     */
    public val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdatedAt) { "A non-null value must be provided for lastUpdatedAt" }
    /**
     * The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.
     */
    public val percentOfTotalTrafficImpacted: kotlin.Double? = builder.percentOfTotalTrafficImpacted
    /**
     * When a health event started.
     */
    public val startedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startedAt) { "A non-null value must be provided for startedAt" }
    /**
     * Health event list member.
     */
    public val status: aws.sdk.kotlin.services.internetmonitor.model.HealthEventStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.HealthEvent = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HealthEvent(")
        append("createdAt=$createdAt,")
        append("endedAt=$endedAt,")
        append("eventArn=$eventArn,")
        append("eventId=$eventId,")
        append("healthScoreThreshold=$healthScoreThreshold,")
        append("impactType=$impactType,")
        append("impactedLocations=$impactedLocations,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("percentOfTotalTrafficImpacted=$percentOfTotalTrafficImpacted,")
        append("startedAt=$startedAt,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (endedAt?.hashCode() ?: 0)
        result = 31 * result + (eventArn.hashCode())
        result = 31 * result + (eventId.hashCode())
        result = 31 * result + (healthScoreThreshold.hashCode())
        result = 31 * result + (impactType.hashCode())
        result = 31 * result + (impactedLocations.hashCode())
        result = 31 * result + (lastUpdatedAt.hashCode())
        result = 31 * result + (percentOfTotalTrafficImpacted?.hashCode() ?: 0)
        result = 31 * result + (startedAt.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HealthEvent

        if (createdAt != other.createdAt) return false
        if (endedAt != other.endedAt) return false
        if (eventArn != other.eventArn) return false
        if (eventId != other.eventId) return false
        if (healthScoreThreshold != other.healthScoreThreshold) return false
        if (impactType != other.impactType) return false
        if (impactedLocations != other.impactedLocations) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (percentOfTotalTrafficImpacted != other.percentOfTotalTrafficImpacted) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.HealthEvent = Builder(this).apply(block).build()

    public class Builder {
        /**
         * When the health event was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time when a health event ended. If the health event is still active, then the end time is not set.
         */
        public var endedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the event.
         */
        public var eventArn: kotlin.String? = null
        /**
         * The internally-generated identifier of a specific network traffic impairment health event.
         */
        public var eventId: kotlin.String? = null
        /**
         * The value of the threshold percentage for performance or availability that was configured when Amazon CloudWatch Internet Monitor created the health event.
         */
        public var healthScoreThreshold: kotlin.Double = 0.0
        /**
         * The type of impairment for a health event.
         */
        public var impactType: aws.sdk.kotlin.services.internetmonitor.model.HealthEventImpactType? = null
        /**
         * The locations impacted by the health event.
         */
        public var impactedLocations: List<ImpactedLocation>? = null
        /**
         * When the health event was last updated.
         */
        public var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.
         */
        public var percentOfTotalTrafficImpacted: kotlin.Double? = null
        /**
         * When a health event started.
         */
        public var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Health event list member.
         */
        public var status: aws.sdk.kotlin.services.internetmonitor.model.HealthEventStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.HealthEvent) : this() {
            this.createdAt = x.createdAt
            this.endedAt = x.endedAt
            this.eventArn = x.eventArn
            this.eventId = x.eventId
            this.healthScoreThreshold = x.healthScoreThreshold
            this.impactType = x.impactType
            this.impactedLocations = x.impactedLocations
            this.lastUpdatedAt = x.lastUpdatedAt
            this.percentOfTotalTrafficImpacted = x.percentOfTotalTrafficImpacted
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.HealthEvent = HealthEvent(this)

        internal fun correctErrors(): Builder {
            if (eventArn == null) eventArn = ""
            if (eventId == null) eventId = ""
            if (impactType == null) impactType = HealthEventImpactType.SdkUnknown("no value provided")
            if (impactedLocations == null) impactedLocations = emptyList()
            if (lastUpdatedAt == null) lastUpdatedAt = Instant.fromEpochSeconds(0)
            if (startedAt == null) startedAt = Instant.fromEpochSeconds(0)
            if (status == null) status = HealthEventStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
