// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



public class GetQueryResultsResponse private constructor(builder: Builder) {
    /**
     * The data results that the query returns. Data is returned in arrays, aligned with the `Fields` for the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application. Then, you can filter the information in the repository by using `FilterParameters` that you define.
     */
    public val data: List<List<String>> = requireNotNull(builder.data) { "A non-null value must be provided for data" }
    /**
     * The fields that the query returns data for. Fields are name-data type pairs, such as `availability_score`-`float`.
     */
    public val fields: List<QueryField> = requireNotNull(builder.fields) { "A non-null value must be provided for fields" }
    /**
     * The token for the next set of results. You receive this token from a previous call.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.GetQueryResultsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetQueryResultsResponse(")
        append("data=$data,")
        append("fields=$fields,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = data.hashCode()
        result = 31 * result + (fields.hashCode())
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetQueryResultsResponse

        if (data != other.data) return false
        if (fields != other.fields) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.GetQueryResultsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The data results that the query returns. Data is returned in arrays, aligned with the `Fields` for the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application. Then, you can filter the information in the repository by using `FilterParameters` that you define.
         */
        public var data: List<List<String>>? = null
        /**
         * The fields that the query returns data for. Fields are name-data type pairs, such as `availability_score`-`float`.
         */
        public var fields: List<QueryField>? = null
        /**
         * The token for the next set of results. You receive this token from a previous call.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.GetQueryResultsResponse) : this() {
            this.data = x.data
            this.fields = x.fields
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.GetQueryResultsResponse = GetQueryResultsResponse(this)

        internal fun correctErrors(): Builder {
            if (data == null) data = emptyList()
            if (fields == null) fields = emptyList()
            return this
        }
    }
}
