// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetMonitorResponse private constructor(builder: Builder) {
    /**
     * The time when the monitor was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The list of health event threshold configurations. The threshold percentage for a health score determines, along with other configuration information, when Internet Monitor creates a health event when there's an internet issue that affects your application end users.
     *
     * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val healthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig? = builder.healthEventsConfig
    /**
     * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.
     */
    public val internetMeasurementsLogDelivery: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery? = builder.internetMeasurementsLogDelivery
    /**
     * The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. This limit can help control billing costs.
     *
     * To learn more, see [Choosing a city-network maximum value ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val maxCityNetworksToMonitor: kotlin.Int? = builder.maxCityNetworksToMonitor
    /**
     * The last time that the monitor was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modifiedAt) { "A non-null value must be provided for modifiedAt" }
    /**
     * The Amazon Resource Name (ARN) of the monitor.
     */
    public val monitorArn: kotlin.String = requireNotNull(builder.monitorArn) { "A non-null value must be provided for monitorArn" }
    /**
     * The name of the monitor.
     */
    public val monitorName: kotlin.String = requireNotNull(builder.monitorName) { "A non-null value must be provided for monitorName" }
    /**
     * The health of the data processing for the monitor.
     */
    public val processingStatus: aws.sdk.kotlin.services.internetmonitor.model.MonitorProcessingStatusCode? = builder.processingStatus
    /**
     * Additional information about the health of the data processing for the monitor.
     */
    public val processingStatusInfo: kotlin.String? = builder.processingStatusInfo
    /**
     * The resources monitored by the monitor. Resources are listed by their Amazon Resource Names (ARNs).
     */
    public val resources: List<String> = requireNotNull(builder.resources) { "A non-null value must be provided for resources" }
    /**
     * The status of the monitor.
     */
    public val status: aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The tags that have been added to monitor.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The percentage of the internet-facing traffic for your application to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.
     *
     * To learn more, see [Choosing an application traffic percentage to monitor ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val trafficPercentageToMonitor: kotlin.Int? = builder.trafficPercentageToMonitor

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.GetMonitorResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMonitorResponse(")
        append("createdAt=$createdAt,")
        append("healthEventsConfig=$healthEventsConfig,")
        append("internetMeasurementsLogDelivery=$internetMeasurementsLogDelivery,")
        append("maxCityNetworksToMonitor=$maxCityNetworksToMonitor,")
        append("modifiedAt=$modifiedAt,")
        append("monitorArn=$monitorArn,")
        append("monitorName=$monitorName,")
        append("processingStatus=$processingStatus,")
        append("processingStatusInfo=$processingStatusInfo,")
        append("resources=$resources,")
        append("status=$status,")
        append("tags=$tags,")
        append("trafficPercentageToMonitor=$trafficPercentageToMonitor")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (healthEventsConfig?.hashCode() ?: 0)
        result = 31 * result + (internetMeasurementsLogDelivery?.hashCode() ?: 0)
        result = 31 * result + (maxCityNetworksToMonitor ?: 0)
        result = 31 * result + (modifiedAt.hashCode())
        result = 31 * result + (monitorArn.hashCode())
        result = 31 * result + (monitorName.hashCode())
        result = 31 * result + (processingStatus?.hashCode() ?: 0)
        result = 31 * result + (processingStatusInfo?.hashCode() ?: 0)
        result = 31 * result + (resources.hashCode())
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (trafficPercentageToMonitor ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMonitorResponse

        if (createdAt != other.createdAt) return false
        if (healthEventsConfig != other.healthEventsConfig) return false
        if (internetMeasurementsLogDelivery != other.internetMeasurementsLogDelivery) return false
        if (maxCityNetworksToMonitor != other.maxCityNetworksToMonitor) return false
        if (modifiedAt != other.modifiedAt) return false
        if (monitorArn != other.monitorArn) return false
        if (monitorName != other.monitorName) return false
        if (processingStatus != other.processingStatus) return false
        if (processingStatusInfo != other.processingStatusInfo) return false
        if (resources != other.resources) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (trafficPercentageToMonitor != other.trafficPercentageToMonitor) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.GetMonitorResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time when the monitor was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The list of health event threshold configurations. The threshold percentage for a health score determines, along with other configuration information, when Internet Monitor creates a health event when there's an internet issue that affects your application end users.
         *
         * For more information, see [ Change health event thresholds](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview) in the Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var healthEventsConfig: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig? = null
        /**
         * Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.
         */
        public var internetMeasurementsLogDelivery: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery? = null
        /**
         * The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. This limit can help control billing costs.
         *
         * To learn more, see [Choosing a city-network maximum value ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var maxCityNetworksToMonitor: kotlin.Int? = null
        /**
         * The last time that the monitor was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the monitor.
         */
        public var monitorArn: kotlin.String? = null
        /**
         * The name of the monitor.
         */
        public var monitorName: kotlin.String? = null
        /**
         * The health of the data processing for the monitor.
         */
        public var processingStatus: aws.sdk.kotlin.services.internetmonitor.model.MonitorProcessingStatusCode? = null
        /**
         * Additional information about the health of the data processing for the monitor.
         */
        public var processingStatusInfo: kotlin.String? = null
        /**
         * The resources monitored by the monitor. Resources are listed by their Amazon Resource Names (ARNs).
         */
        public var resources: List<String>? = null
        /**
         * The status of the monitor.
         */
        public var status: aws.sdk.kotlin.services.internetmonitor.model.MonitorConfigState? = null
        /**
         * The tags that have been added to monitor.
         */
        public var tags: Map<String, String>? = null
        /**
         * The percentage of the internet-facing traffic for your application to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.
         *
         * To learn more, see [Choosing an application traffic percentage to monitor ](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var trafficPercentageToMonitor: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.GetMonitorResponse) : this() {
            this.createdAt = x.createdAt
            this.healthEventsConfig = x.healthEventsConfig
            this.internetMeasurementsLogDelivery = x.internetMeasurementsLogDelivery
            this.maxCityNetworksToMonitor = x.maxCityNetworksToMonitor
            this.modifiedAt = x.modifiedAt
            this.monitorArn = x.monitorArn
            this.monitorName = x.monitorName
            this.processingStatus = x.processingStatus
            this.processingStatusInfo = x.processingStatusInfo
            this.resources = x.resources
            this.status = x.status
            this.tags = x.tags
            this.trafficPercentageToMonitor = x.trafficPercentageToMonitor
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.GetMonitorResponse = GetMonitorResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig] inside the given [block]
         */
        public fun healthEventsConfig(block: aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig.Builder.() -> kotlin.Unit) {
            this.healthEventsConfig = aws.sdk.kotlin.services.internetmonitor.model.HealthEventsConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery] inside the given [block]
         */
        public fun internetMeasurementsLogDelivery(block: aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery.Builder.() -> kotlin.Unit) {
            this.internetMeasurementsLogDelivery = aws.sdk.kotlin.services.internetmonitor.model.InternetMeasurementsLogDelivery.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (modifiedAt == null) modifiedAt = Instant.fromEpochSeconds(0)
            if (monitorArn == null) monitorArn = ""
            if (monitorName == null) monitorName = ""
            if (resources == null) resources = emptyList()
            if (status == null) status = MonitorConfigState.SdkUnknown("no value provided")
            return this
        }
    }
}
