// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * A filter that you use with the results of a Amazon CloudWatch Internet Monitor query that you created and ran. The query sets up a repository of data that is a subset of your application's Internet Monitor data. `FilterParameter` is a string that defines how you want to filter the repository of data to return a set of results, based on your criteria.
 *
 * The filter parameters that you can specify depend on the query type that you used to create the repository, since each query type returns a different set of Internet Monitor data.
 *
 * For each filter, you specify a field (such as `city`), an operator (such as `not_equals`, and a value or array of values (such as `["Seattle", "Redmond"]`). Separate values in the array with commas.
 *
 * For more information about specifying filter parameters, see [Using the Amazon CloudWatch Internet Monitor query interface](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html) in the Amazon CloudWatch Internet Monitor User Guide.
 */
public class FilterParameter private constructor(builder: Builder) {
    /**
     * A data field that you want to filter, to further scope your application's Internet Monitor data in a repository that you created by running a query. A field might be `city`, for example. The field must be one of the fields that was returned by the specific query that you used to create the repository.
     */
    public val field: kotlin.String? = builder.field
    /**
     * The operator to use with the filter field and a value, such as `not_equals`.
     */
    public val operator: aws.sdk.kotlin.services.internetmonitor.model.Operator? = builder.operator
    /**
     * One or more values to be used, together with the specified operator, to filter data for a query. For example, you could specify an array of values such as `["Seattle", "Redmond"]`. Values in the array are separated by commas.
     */
    public val values: List<String>? = builder.values

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.FilterParameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FilterParameter(")
        append("field=$field,")
        append("operator=$operator,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = field?.hashCode() ?: 0
        result = 31 * result + (operator?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FilterParameter

        if (field != other.field) return false
        if (operator != other.operator) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.FilterParameter = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A data field that you want to filter, to further scope your application's Internet Monitor data in a repository that you created by running a query. A field might be `city`, for example. The field must be one of the fields that was returned by the specific query that you used to create the repository.
         */
        public var field: kotlin.String? = null
        /**
         * The operator to use with the filter field and a value, such as `not_equals`.
         */
        public var operator: aws.sdk.kotlin.services.internetmonitor.model.Operator? = null
        /**
         * One or more values to be used, together with the specified operator, to filter data for a query. For example, you could specify an array of values such as `["Seattle", "Redmond"]`. Values in the array are separated by commas.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.FilterParameter) : this() {
            this.field = x.field
            this.operator = x.operator
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.FilterParameter = FilterParameter(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
