// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.internetmonitor.model



/**
 * Amazon CloudWatch Internet Monitor calculates measurements about the availability for your application's internet traffic between client locations and Amazon Web Services. Amazon Web Services has substantial historical data about internet performance and availability between Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to an estimated baseline that's already calculated. To make it easier to see those drops, we report that information to you in the form of health scores: a performance score and an availability score.
 *
 * Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing an availability drop for that pair.
 *
 * For more information, see [How Internet Monitor calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *Amazon CloudWatch User Guide*.
 */
public class AvailabilityMeasurement private constructor(builder: Builder) {
    /**
     * Experience scores, or health scores are calculated for different geographic and network provider combinations (that is, different granularities) and also summed into global scores. If you view performance or availability scores without filtering for any specific geography or service provider, Amazon CloudWatch Internet Monitor provides global health scores.
     *
     * The Amazon CloudWatch Internet Monitor chapter in the *CloudWatch User Guide* includes detailed information about how Internet Monitor calculates health scores, including performance and availability scores, and when it creates and resolves health events. For more information, see [How Amazon Web Services calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
     */
    public val experienceScore: kotlin.Double? = builder.experienceScore
    /**
     * The percentage of impact caused by a health event for client location traffic globally.
     *
     * For information about how Internet Monitor calculates impact, see [Inside Internet Monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html) in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.
     */
    public val percentOfClientLocationImpacted: kotlin.Double? = builder.percentOfClientLocationImpacted
    /**
     * The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.
     *
     * For information about how Internet Monitor calculates impact, see [How Internet Monitor works](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html) in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.
     */
    public val percentOfTotalTrafficImpacted: kotlin.Double? = builder.percentOfTotalTrafficImpacted

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AvailabilityMeasurement(")
        append("experienceScore=$experienceScore,")
        append("percentOfClientLocationImpacted=$percentOfClientLocationImpacted,")
        append("percentOfTotalTrafficImpacted=$percentOfTotalTrafficImpacted")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = experienceScore?.hashCode() ?: 0
        result = 31 * result + (percentOfClientLocationImpacted?.hashCode() ?: 0)
        result = 31 * result + (percentOfTotalTrafficImpacted?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AvailabilityMeasurement

        if (experienceScore != other.experienceScore) return false
        if (percentOfClientLocationImpacted != other.percentOfClientLocationImpacted) return false
        if (percentOfTotalTrafficImpacted != other.percentOfTotalTrafficImpacted) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Experience scores, or health scores are calculated for different geographic and network provider combinations (that is, different granularities) and also summed into global scores. If you view performance or availability scores without filtering for any specific geography or service provider, Amazon CloudWatch Internet Monitor provides global health scores.
         *
         * The Amazon CloudWatch Internet Monitor chapter in the *CloudWatch User Guide* includes detailed information about how Internet Monitor calculates health scores, including performance and availability scores, and when it creates and resolves health events. For more information, see [How Amazon Web Services calculates performance and availability scores](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores) in the Amazon CloudWatch Internet Monitor section of the *CloudWatch User Guide*.
         */
        public var experienceScore: kotlin.Double? = null
        /**
         * The percentage of impact caused by a health event for client location traffic globally.
         *
         * For information about how Internet Monitor calculates impact, see [Inside Internet Monitor](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html) in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.
         */
        public var percentOfClientLocationImpacted: kotlin.Double? = null
        /**
         * The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.
         *
         * For information about how Internet Monitor calculates impact, see [How Internet Monitor works](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html) in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.
         */
        public var percentOfTotalTrafficImpacted: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement) : this() {
            this.experienceScore = x.experienceScore
            this.percentOfClientLocationImpacted = x.percentOfClientLocationImpacted
            this.percentOfTotalTrafficImpacted = x.percentOfTotalTrafficImpacted
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.internetmonitor.model.AvailabilityMeasurement = AvailabilityMeasurement(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
