// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspectorscan.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request processing has failed because of an unknown error, exception or failure.
 */
public class InternalServerException private constructor(builder: Builder) : InspectorScanException(builder.message) {

    /**
     * The reason for the validation failure.
     */
    public val reason: aws.sdk.kotlin.services.inspectorscan.model.InternalServerExceptionReason = requireNotNull(builder.reason) { "A non-null value must be provided for reason" }
    /**
     * The number of seconds to wait before retrying the request.
     */
    public val retryAfterSeconds: kotlin.Int? = builder.retryAfterSeconds

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = false
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Server
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspectorscan.model.InternalServerException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InternalServerException(")
        append("message=$message,")
        append("reason=$reason,")
        append("retryAfterSeconds=$retryAfterSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (reason.hashCode())
        result = 31 * result + (retryAfterSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InternalServerException

        if (message != other.message) return false
        if (reason != other.reason) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspectorscan.model.InternalServerException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The reason for the validation failure.
         */
        public var reason: aws.sdk.kotlin.services.inspectorscan.model.InternalServerExceptionReason? = null
        /**
         * The number of seconds to wait before retrying the request.
         */
        public var retryAfterSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspectorscan.model.InternalServerException) : this() {
            this.message = x.message
            this.reason = x.reason
            this.retryAfterSeconds = x.retryAfterSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspectorscan.model.InternalServerException = InternalServerException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            if (reason == null) reason = InternalServerExceptionReason.SdkUnknown("no value provided")
            return this
        }
    }
}
