// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.serde

import aws.sdk.kotlin.services.inspector2.model.Counts
import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListCoverageStatisticsOperationDeserializer: HttpDeserializer.NonStreaming<ListCoverageStatisticsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListCoverageStatisticsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListCoverageStatisticsError(context, call, payload)
        }
        val builder = ListCoverageStatisticsResponse.Builder()

        if (payload != null) {
            deserializeListCoverageStatisticsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListCoverageStatisticsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListCoverageStatisticsOperationBody(builder: ListCoverageStatisticsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COUNTSBYGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("countsByGroup"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val TOTALCOUNTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("totalCounts"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COUNTSBYGROUP_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(TOTALCOUNTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COUNTSBYGROUP_DESCRIPTOR.index -> builder.countsByGroup =
                    deserializer.deserializeList(COUNTSBYGROUP_DESCRIPTOR) {
                        val col0 = mutableListOf<Counts>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCountsDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TOTALCOUNTS_DESCRIPTOR.index -> builder.totalCounts = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
