// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An object that contains details about a member account in your organization that failed to activate Amazon Inspector deep inspection.
 */
public class FailedMemberAccountEc2DeepInspectionStatusState private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account of the organization member that failed to activate Amazon Inspector deep inspection.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
     */
    public val ec2ScanStatus: aws.sdk.kotlin.services.inspector2.model.Status? = builder.ec2ScanStatus
    /**
     * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FailedMemberAccountEc2DeepInspectionStatusState(")
        append("accountId=$accountId,")
        append("ec2ScanStatus=$ec2ScanStatus,")
        append("errorMessage=$errorMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (ec2ScanStatus?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FailedMemberAccountEc2DeepInspectionStatusState

        if (accountId != other.accountId) return false
        if (ec2ScanStatus != other.ec2ScanStatus) return false
        if (errorMessage != other.errorMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account of the organization member that failed to activate Amazon Inspector deep inspection.
         */
        public var accountId: kotlin.String? = null
        /**
         * The status of EC2 scanning in the account that failed to activate Amazon Inspector deep inspection.
         */
        public var ec2ScanStatus: aws.sdk.kotlin.services.inspector2.model.Status? = null
        /**
         * The error message explaining why the account failed to activate Amazon Inspector deep inspection.
         */
        public var errorMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState) : this() {
            this.accountId = x.accountId
            this.ec2ScanStatus = x.ec2ScanStatus
            this.errorMessage = x.errorMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState = FailedMemberAccountEc2DeepInspectionStatusState(this)

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            return this
        }
    }
}
