// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary of information about the Amazon Web Services Lambda function.
 */
public class AwsLambdaFunctionDetails private constructor(builder: Builder) {
    /**
     * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a string array with one of the valid values. The default architecture value is `x86_64`.
     */
    public val architectures: List<Architecture>? = builder.architectures
    /**
     * The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
     */
    public val codeSha256: kotlin.String = requireNotNull(builder.codeSha256) { "A non-null value must be provided for codeSha256" }
    /**
     * The Amazon Web Services Lambda function's execution role.
     */
    public val executionRoleArn: kotlin.String = requireNotNull(builder.executionRoleArn) { "A non-null value must be provided for executionRoleArn" }
    /**
     * The name of the Amazon Web Services Lambda function.
     */
    public val functionName: kotlin.String = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * The date and time that a user last updated the configuration, in [ISO 8601 format](https://www.iso.org/iso-8601-date-and-time-format.html)
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The Amazon Web Services Lambda function's [ layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). A Lambda function can have up to five layers.
     */
    public val layers: List<String>? = builder.layers
    /**
     * The type of deployment package. Set to `Image` for container image and set `Zip` for .zip file archive.
     */
    public val packageType: aws.sdk.kotlin.services.inspector2.model.PackageType? = builder.packageType
    /**
     * The runtime environment for the Amazon Web Services Lambda function.
     */
    public val runtime: aws.sdk.kotlin.services.inspector2.model.Runtime = requireNotNull(builder.runtime) { "A non-null value must be provided for runtime" }
    /**
     * The version of the Amazon Web Services Lambda function.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }
    /**
     * The Amazon Web Services Lambda function's networking configuration.
     */
    public val vpcConfig: aws.sdk.kotlin.services.inspector2.model.LambdaVpcConfig? = builder.vpcConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.AwsLambdaFunctionDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsLambdaFunctionDetails(")
        append("architectures=$architectures,")
        append("codeSha256=$codeSha256,")
        append("executionRoleArn=$executionRoleArn,")
        append("functionName=$functionName,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("layers=$layers,")
        append("packageType=$packageType,")
        append("runtime=$runtime,")
        append("version=$version,")
        append("vpcConfig=$vpcConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = architectures?.hashCode() ?: 0
        result = 31 * result + (codeSha256.hashCode())
        result = 31 * result + (executionRoleArn.hashCode())
        result = 31 * result + (functionName.hashCode())
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (layers?.hashCode() ?: 0)
        result = 31 * result + (packageType?.hashCode() ?: 0)
        result = 31 * result + (runtime.hashCode())
        result = 31 * result + (version.hashCode())
        result = 31 * result + (vpcConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsLambdaFunctionDetails

        if (architectures != other.architectures) return false
        if (codeSha256 != other.codeSha256) return false
        if (executionRoleArn != other.executionRoleArn) return false
        if (functionName != other.functionName) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (layers != other.layers) return false
        if (packageType != other.packageType) return false
        if (runtime != other.runtime) return false
        if (version != other.version) return false
        if (vpcConfig != other.vpcConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.AwsLambdaFunctionDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The instruction set architecture that the Amazon Web Services Lambda function supports. Architecture is a string array with one of the valid values. The default architecture value is `x86_64`.
         */
        public var architectures: List<Architecture>? = null
        /**
         * The SHA256 hash of the Amazon Web Services Lambda function's deployment package.
         */
        public var codeSha256: kotlin.String? = null
        /**
         * The Amazon Web Services Lambda function's execution role.
         */
        public var executionRoleArn: kotlin.String? = null
        /**
         * The name of the Amazon Web Services Lambda function.
         */
        public var functionName: kotlin.String? = null
        /**
         * The date and time that a user last updated the configuration, in [ISO 8601 format](https://www.iso.org/iso-8601-date-and-time-format.html)
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services Lambda function's [ layers](https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html). A Lambda function can have up to five layers.
         */
        public var layers: List<String>? = null
        /**
         * The type of deployment package. Set to `Image` for container image and set `Zip` for .zip file archive.
         */
        public var packageType: aws.sdk.kotlin.services.inspector2.model.PackageType? = null
        /**
         * The runtime environment for the Amazon Web Services Lambda function.
         */
        public var runtime: aws.sdk.kotlin.services.inspector2.model.Runtime? = null
        /**
         * The version of the Amazon Web Services Lambda function.
         */
        public var version: kotlin.String? = null
        /**
         * The Amazon Web Services Lambda function's networking configuration.
         */
        public var vpcConfig: aws.sdk.kotlin.services.inspector2.model.LambdaVpcConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.AwsLambdaFunctionDetails) : this() {
            this.architectures = x.architectures
            this.codeSha256 = x.codeSha256
            this.executionRoleArn = x.executionRoleArn
            this.functionName = x.functionName
            this.lastModifiedAt = x.lastModifiedAt
            this.layers = x.layers
            this.packageType = x.packageType
            this.runtime = x.runtime
            this.version = x.version
            this.vpcConfig = x.vpcConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.AwsLambdaFunctionDetails = AwsLambdaFunctionDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.LambdaVpcConfig] inside the given [block]
         */
        public fun vpcConfig(block: aws.sdk.kotlin.services.inspector2.model.LambdaVpcConfig.Builder.() -> kotlin.Unit) {
            this.vpcConfig = aws.sdk.kotlin.services.inspector2.model.LambdaVpcConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (codeSha256 == null) codeSha256 = ""
            if (executionRoleArn == null) executionRoleArn = ""
            if (functionName == null) functionName = ""
            if (runtime == null) runtime = Runtime.SdkUnknown("no value provided")
            if (version == null) version = ""
            return this
        }
    }
}
