// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about a specific vulnerability Amazon Inspector can detect.
 */
public class Vulnerability private constructor(builder: Builder) {
    /**
     * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the vulnerability.
     */
    public val atigData: aws.sdk.kotlin.services.inspector2.model.AtigData? = builder.atigData
    /**
     * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the vulnerability.
     */
    public val cisaData: aws.sdk.kotlin.services.inspector2.model.CisaData? = builder.cisaData
    /**
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
     */
    public val cvss2: aws.sdk.kotlin.services.inspector2.model.Cvss2? = builder.cvss2
    /**
     * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
     */
    public val cvss3: aws.sdk.kotlin.services.inspector2.model.Cvss3? = builder.cvss3
    /**
     * The Common Weakness Enumeration (CWE) associated with the vulnerability.
     */
    public val cwes: List<String>? = builder.cwes
    /**
     * A description of the vulnerability.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Platforms that the vulnerability can be detected on.
     */
    public val detectionPlatforms: List<String>? = builder.detectionPlatforms
    /**
     * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
     */
    public val epss: aws.sdk.kotlin.services.inspector2.model.Epss? = builder.epss
    /**
     * An object that contains details on when the exploit was observed.
     */
    public val exploitObserved: aws.sdk.kotlin.services.inspector2.model.ExploitObserved? = builder.exploitObserved
    /**
     * The ID for the specific vulnerability.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Links to various resources with more information on this vulnerability.
     */
    public val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * A list of related vulnerabilities.
     */
    public val relatedVulnerabilities: List<String>? = builder.relatedVulnerabilities
    /**
     * The source of the vulnerability information. Possible results are `RHEL`, `AMAZON_CVE`, `DEBIAN` or `NVD`.
     */
    public val source: aws.sdk.kotlin.services.inspector2.model.VulnerabilitySource? = builder.source
    /**
     * A link to the official source material for this vulnerability.
     */
    public val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * The date and time when the vendor created this vulnerability.
     */
    public val vendorCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.vendorCreatedAt
    /**
     * The severity assigned by the vendor.
     */
    public val vendorSeverity: kotlin.String? = builder.vendorSeverity
    /**
     * The date and time when the vendor last updated this vulnerability.
     */
    public val vendorUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.vendorUpdatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.Vulnerability = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Vulnerability(")
        append("atigData=$atigData,")
        append("cisaData=$cisaData,")
        append("cvss2=$cvss2,")
        append("cvss3=$cvss3,")
        append("cwes=$cwes,")
        append("description=$description,")
        append("detectionPlatforms=$detectionPlatforms,")
        append("epss=$epss,")
        append("exploitObserved=$exploitObserved,")
        append("id=$id,")
        append("referenceUrls=$referenceUrls,")
        append("relatedVulnerabilities=$relatedVulnerabilities,")
        append("source=$source,")
        append("sourceUrl=$sourceUrl,")
        append("vendorCreatedAt=$vendorCreatedAt,")
        append("vendorSeverity=$vendorSeverity,")
        append("vendorUpdatedAt=$vendorUpdatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = atigData?.hashCode() ?: 0
        result = 31 * result + (cisaData?.hashCode() ?: 0)
        result = 31 * result + (cvss2?.hashCode() ?: 0)
        result = 31 * result + (cvss3?.hashCode() ?: 0)
        result = 31 * result + (cwes?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (detectionPlatforms?.hashCode() ?: 0)
        result = 31 * result + (epss?.hashCode() ?: 0)
        result = 31 * result + (exploitObserved?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (relatedVulnerabilities?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (vendorCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (vendorSeverity?.hashCode() ?: 0)
        result = 31 * result + (vendorUpdatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Vulnerability

        if (atigData != other.atigData) return false
        if (cisaData != other.cisaData) return false
        if (cvss2 != other.cvss2) return false
        if (cvss3 != other.cvss3) return false
        if (cwes != other.cwes) return false
        if (description != other.description) return false
        if (detectionPlatforms != other.detectionPlatforms) return false
        if (epss != other.epss) return false
        if (exploitObserved != other.exploitObserved) return false
        if (id != other.id) return false
        if (referenceUrls != other.referenceUrls) return false
        if (relatedVulnerabilities != other.relatedVulnerabilities) return false
        if (source != other.source) return false
        if (sourceUrl != other.sourceUrl) return false
        if (vendorCreatedAt != other.vendorCreatedAt) return false
        if (vendorSeverity != other.vendorSeverity) return false
        if (vendorUpdatedAt != other.vendorUpdatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.Vulnerability = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An object that contains information about the Amazon Web Services Threat Intel Group (ATIG) details for the vulnerability.
         */
        public var atigData: aws.sdk.kotlin.services.inspector2.model.AtigData? = null
        /**
         * An object that contains the Cybersecurity and Infrastructure Security Agency (CISA) details for the vulnerability.
         */
        public var cisaData: aws.sdk.kotlin.services.inspector2.model.CisaData? = null
        /**
         * An object that contains the Common Vulnerability Scoring System (CVSS) Version 2 details for the vulnerability.
         */
        public var cvss2: aws.sdk.kotlin.services.inspector2.model.Cvss2? = null
        /**
         * An object that contains the Common Vulnerability Scoring System (CVSS) Version 3 details for the vulnerability.
         */
        public var cvss3: aws.sdk.kotlin.services.inspector2.model.Cvss3? = null
        /**
         * The Common Weakness Enumeration (CWE) associated with the vulnerability.
         */
        public var cwes: List<String>? = null
        /**
         * A description of the vulnerability.
         */
        public var description: kotlin.String? = null
        /**
         * Platforms that the vulnerability can be detected on.
         */
        public var detectionPlatforms: List<String>? = null
        /**
         * An object that contains the Exploit Prediction Scoring System (EPSS) score for a vulnerability.
         */
        public var epss: aws.sdk.kotlin.services.inspector2.model.Epss? = null
        /**
         * An object that contains details on when the exploit was observed.
         */
        public var exploitObserved: aws.sdk.kotlin.services.inspector2.model.ExploitObserved? = null
        /**
         * The ID for the specific vulnerability.
         */
        public var id: kotlin.String? = null
        /**
         * Links to various resources with more information on this vulnerability.
         */
        public var referenceUrls: List<String>? = null
        /**
         * A list of related vulnerabilities.
         */
        public var relatedVulnerabilities: List<String>? = null
        /**
         * The source of the vulnerability information. Possible results are `RHEL`, `AMAZON_CVE`, `DEBIAN` or `NVD`.
         */
        public var source: aws.sdk.kotlin.services.inspector2.model.VulnerabilitySource? = null
        /**
         * A link to the official source material for this vulnerability.
         */
        public var sourceUrl: kotlin.String? = null
        /**
         * The date and time when the vendor created this vulnerability.
         */
        public var vendorCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The severity assigned by the vendor.
         */
        public var vendorSeverity: kotlin.String? = null
        /**
         * The date and time when the vendor last updated this vulnerability.
         */
        public var vendorUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.Vulnerability) : this() {
            this.atigData = x.atigData
            this.cisaData = x.cisaData
            this.cvss2 = x.cvss2
            this.cvss3 = x.cvss3
            this.cwes = x.cwes
            this.description = x.description
            this.detectionPlatforms = x.detectionPlatforms
            this.epss = x.epss
            this.exploitObserved = x.exploitObserved
            this.id = x.id
            this.referenceUrls = x.referenceUrls
            this.relatedVulnerabilities = x.relatedVulnerabilities
            this.source = x.source
            this.sourceUrl = x.sourceUrl
            this.vendorCreatedAt = x.vendorCreatedAt
            this.vendorSeverity = x.vendorSeverity
            this.vendorUpdatedAt = x.vendorUpdatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.Vulnerability = Vulnerability(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.AtigData] inside the given [block]
         */
        public fun atigData(block: aws.sdk.kotlin.services.inspector2.model.AtigData.Builder.() -> kotlin.Unit) {
            this.atigData = aws.sdk.kotlin.services.inspector2.model.AtigData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.CisaData] inside the given [block]
         */
        public fun cisaData(block: aws.sdk.kotlin.services.inspector2.model.CisaData.Builder.() -> kotlin.Unit) {
            this.cisaData = aws.sdk.kotlin.services.inspector2.model.CisaData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.Cvss2] inside the given [block]
         */
        public fun cvss2(block: aws.sdk.kotlin.services.inspector2.model.Cvss2.Builder.() -> kotlin.Unit) {
            this.cvss2 = aws.sdk.kotlin.services.inspector2.model.Cvss2.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.Cvss3] inside the given [block]
         */
        public fun cvss3(block: aws.sdk.kotlin.services.inspector2.model.Cvss3.Builder.() -> kotlin.Unit) {
            this.cvss3 = aws.sdk.kotlin.services.inspector2.model.Cvss3.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.Epss] inside the given [block]
         */
        public fun epss(block: aws.sdk.kotlin.services.inspector2.model.Epss.Builder.() -> kotlin.Unit) {
            this.epss = aws.sdk.kotlin.services.inspector2.model.Epss.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ExploitObserved] inside the given [block]
         */
        public fun exploitObserved(block: aws.sdk.kotlin.services.inspector2.model.ExploitObserved.Builder.() -> kotlin.Unit) {
            this.exploitObserved = aws.sdk.kotlin.services.inspector2.model.ExploitObserved.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            return this
        }
    }
}
