// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A response that contains details on the results of a finding aggregation by repository.
 */
public class RepositoryAggregationResponse private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account associated with the findings.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The number of container images impacted by the findings.
     */
    public val affectedImages: kotlin.Long? = builder.affectedImages
    /**
     * The name of the repository associated with the findings.
     */
    public val repository: kotlin.String = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }
    /**
     * An object that represent the count of matched findings per severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.RepositoryAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RepositoryAggregationResponse(")
        append("accountId=$accountId,")
        append("affectedImages=$affectedImages,")
        append("repository=$repository,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (affectedImages?.hashCode() ?: 0)
        result = 31 * result + (repository.hashCode())
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RepositoryAggregationResponse

        if (accountId != other.accountId) return false
        if (affectedImages != other.affectedImages) return false
        if (repository != other.repository) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.RepositoryAggregationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account associated with the findings.
         */
        public var accountId: kotlin.String? = null
        /**
         * The number of container images impacted by the findings.
         */
        public var affectedImages: kotlin.Long? = null
        /**
         * The name of the repository associated with the findings.
         */
        public var repository: kotlin.String? = null
        /**
         * An object that represent the count of matched findings per severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.RepositoryAggregationResponse) : this() {
            this.accountId = x.accountId
            this.affectedImages = x.affectedImages
            this.repository = x.repository
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.RepositoryAggregationResponse = RepositoryAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (repository == null) repository = ""
            return this
        }
    }
}
