// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object that contains details about a resource covered by Amazon Inspector.
 */
public class CoveredResource private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the covered resource.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The date and time the resource was last checked for vulnerabilities.
     */
    public val lastScannedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastScannedAt
    /**
     * The ID of the covered resource.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * An object that contains details about the metadata.
     */
    public val resourceMetadata: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata? = builder.resourceMetadata
    /**
     * The type of the covered resource.
     */
    public val resourceType: aws.sdk.kotlin.services.inspector2.model.CoverageResourceType = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * The scan method that is applied to the instance.
     */
    public val scanMode: aws.sdk.kotlin.services.inspector2.model.ScanMode? = builder.scanMode
    /**
     * The status of the scan covering the resource.
     */
    public val scanStatus: aws.sdk.kotlin.services.inspector2.model.ScanStatus? = builder.scanStatus
    /**
     * The Amazon Inspector scan type covering the resource.
     */
    public val scanType: aws.sdk.kotlin.services.inspector2.model.ScanType = requireNotNull(builder.scanType) { "A non-null value must be provided for scanType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CoveredResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoveredResource(")
        append("accountId=$accountId,")
        append("lastScannedAt=$lastScannedAt,")
        append("resourceId=$resourceId,")
        append("resourceMetadata=$resourceMetadata,")
        append("resourceType=$resourceType,")
        append("scanMode=$scanMode,")
        append("scanStatus=$scanStatus,")
        append("scanType=$scanType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (lastScannedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (resourceMetadata?.hashCode() ?: 0)
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (scanMode?.hashCode() ?: 0)
        result = 31 * result + (scanStatus?.hashCode() ?: 0)
        result = 31 * result + (scanType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoveredResource

        if (accountId != other.accountId) return false
        if (lastScannedAt != other.lastScannedAt) return false
        if (resourceId != other.resourceId) return false
        if (resourceMetadata != other.resourceMetadata) return false
        if (resourceType != other.resourceType) return false
        if (scanMode != other.scanMode) return false
        if (scanStatus != other.scanStatus) return false
        if (scanType != other.scanType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CoveredResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account ID of the covered resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * The date and time the resource was last checked for vulnerabilities.
         */
        public var lastScannedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the covered resource.
         */
        public var resourceId: kotlin.String? = null
        /**
         * An object that contains details about the metadata.
         */
        public var resourceMetadata: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata? = null
        /**
         * The type of the covered resource.
         */
        public var resourceType: aws.sdk.kotlin.services.inspector2.model.CoverageResourceType? = null
        /**
         * The scan method that is applied to the instance.
         */
        public var scanMode: aws.sdk.kotlin.services.inspector2.model.ScanMode? = null
        /**
         * The status of the scan covering the resource.
         */
        public var scanStatus: aws.sdk.kotlin.services.inspector2.model.ScanStatus? = null
        /**
         * The Amazon Inspector scan type covering the resource.
         */
        public var scanType: aws.sdk.kotlin.services.inspector2.model.ScanType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CoveredResource) : this() {
            this.accountId = x.accountId
            this.lastScannedAt = x.lastScannedAt
            this.resourceId = x.resourceId
            this.resourceMetadata = x.resourceMetadata
            this.resourceType = x.resourceType
            this.scanMode = x.scanMode
            this.scanStatus = x.scanStatus
            this.scanType = x.scanType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CoveredResource = CoveredResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata] inside the given [block]
         */
        public fun resourceMetadata(block: aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata.Builder.() -> kotlin.Unit) {
            this.resourceMetadata = aws.sdk.kotlin.services.inspector2.model.ResourceScanMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ScanStatus] inside the given [block]
         */
        public fun scanStatus(block: aws.sdk.kotlin.services.inspector2.model.ScanStatus.Builder.() -> kotlin.Unit) {
            this.scanStatus = aws.sdk.kotlin.services.inspector2.model.ScanStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            if (resourceId == null) resourceId = ""
            if (resourceType == null) resourceType = CoverageResourceType.SdkUnknown("no value provided")
            if (scanType == null) scanType = ScanType.SdkUnknown("no value provided")
            return this
        }
    }
}
