// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.paginators

import aws.sdk.kotlin.services.inspector2.Inspector2Client
import aws.sdk.kotlin.services.inspector2.model.AggregationResponse
import aws.sdk.kotlin.services.inspector2.model.CisCheckAggregation
import aws.sdk.kotlin.services.inspector2.model.CisScan
import aws.sdk.kotlin.services.inspector2.model.CisScanConfiguration
import aws.sdk.kotlin.services.inspector2.model.CisScanResultDetails
import aws.sdk.kotlin.services.inspector2.model.CisTargetResourceAggregation
import aws.sdk.kotlin.services.inspector2.model.Counts
import aws.sdk.kotlin.services.inspector2.model.CoveredResource
import aws.sdk.kotlin.services.inspector2.model.DelegatedAdminAccount
import aws.sdk.kotlin.services.inspector2.model.Filter
import aws.sdk.kotlin.services.inspector2.model.Finding
import aws.sdk.kotlin.services.inspector2.model.GetCisScanResultDetailsRequest
import aws.sdk.kotlin.services.inspector2.model.GetCisScanResultDetailsResponse
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsRequest
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanConfigurationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanConfigurationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScansRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScansResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsResponse
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsRequest
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFiltersRequest
import aws.sdk.kotlin.services.inspector2.model.ListFiltersResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector2.model.ListMembersRequest
import aws.sdk.kotlin.services.inspector2.model.ListMembersResponse
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsRequest
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsResponse
import aws.sdk.kotlin.services.inspector2.model.Member
import aws.sdk.kotlin.services.inspector2.model.Permission
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesRequest
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesResponse
import aws.sdk.kotlin.services.inspector2.model.UsageTotal
import aws.sdk.kotlin.services.inspector2.model.Vulnerability
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetCisScanResultDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetCisScanResultDetailsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCisScanResultDetailsResponse]
 */
public fun Inspector2Client.getCisScanResultDetailsPaginated(initialRequest: GetCisScanResultDetailsRequest): Flow<GetCisScanResultDetailsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getCisScanResultDetailsPaginated.getCisScanResultDetails(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [GetCisScanResultDetailsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetCisScanResultDetailsResponse]
 */
public fun Inspector2Client.getCisScanResultDetailsPaginated(block: GetCisScanResultDetailsRequest.Builder.() -> Unit): Flow<GetCisScanResultDetailsResponse> =
    getCisScanResultDetailsPaginated(GetCisScanResultDetailsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getCisScanResultDetailsPaginated]
 * to access the nested member [CisScanResultDetails]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CisScanResultDetails]
 */
@JvmName("getCisScanResultDetailsResponseCisScanResultDetails")
public fun Flow<GetCisScanResultDetailsResponse>.scanResultDetails(): Flow<CisScanResultDetails> =
    transform() { response ->
        response.scanResultDetails?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountPermissionsResponse]
 */
public fun Inspector2Client.listAccountPermissionsPaginated(initialRequest: ListAccountPermissionsRequest = ListAccountPermissionsRequest { }): Flow<ListAccountPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountPermissionsPaginated.listAccountPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountPermissionsResponse]
 */
public fun Inspector2Client.listAccountPermissionsPaginated(block: ListAccountPermissionsRequest.Builder.() -> Unit): Flow<ListAccountPermissionsResponse> =
    listAccountPermissionsPaginated(ListAccountPermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountPermissionsPaginated]
 * to access the nested member [Permission]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Permission]
 */
@JvmName("listAccountPermissionsResponsePermission")
public fun Flow<ListAccountPermissionsResponse>.permissions(): Flow<Permission> =
    transform() { response ->
        response.permissions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCisScanConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCisScanConfigurationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanConfigurationsResponse]
 */
public fun Inspector2Client.listCisScanConfigurationsPaginated(initialRequest: ListCisScanConfigurationsRequest = ListCisScanConfigurationsRequest { }): Flow<ListCisScanConfigurationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCisScanConfigurationsPaginated.listCisScanConfigurations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCisScanConfigurationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanConfigurationsResponse]
 */
public fun Inspector2Client.listCisScanConfigurationsPaginated(block: ListCisScanConfigurationsRequest.Builder.() -> Unit): Flow<ListCisScanConfigurationsResponse> =
    listCisScanConfigurationsPaginated(ListCisScanConfigurationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCisScanConfigurationsPaginated]
 * to access the nested member [CisScanConfiguration]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CisScanConfiguration]
 */
@JvmName("listCisScanConfigurationsResponseCisScanConfiguration")
public fun Flow<ListCisScanConfigurationsResponse>.scanConfigurations(): Flow<CisScanConfiguration> =
    transform() { response ->
        response.scanConfigurations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCisScanResultsAggregatedByChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCisScanResultsAggregatedByChecksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanResultsAggregatedByChecksResponse]
 */
public fun Inspector2Client.listCisScanResultsAggregatedByChecksPaginated(initialRequest: ListCisScanResultsAggregatedByChecksRequest): Flow<ListCisScanResultsAggregatedByChecksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCisScanResultsAggregatedByChecksPaginated.listCisScanResultsAggregatedByChecks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCisScanResultsAggregatedByChecksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanResultsAggregatedByChecksResponse]
 */
public fun Inspector2Client.listCisScanResultsAggregatedByChecksPaginated(block: ListCisScanResultsAggregatedByChecksRequest.Builder.() -> Unit): Flow<ListCisScanResultsAggregatedByChecksResponse> =
    listCisScanResultsAggregatedByChecksPaginated(ListCisScanResultsAggregatedByChecksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCisScanResultsAggregatedByChecksPaginated]
 * to access the nested member [CisCheckAggregation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CisCheckAggregation]
 */
@JvmName("listCisScanResultsAggregatedByChecksResponseCisCheckAggregation")
public fun Flow<ListCisScanResultsAggregatedByChecksResponse>.checkAggregations(): Flow<CisCheckAggregation> =
    transform() { response ->
        response.checkAggregations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCisScanResultsAggregatedByTargetResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCisScanResultsAggregatedByTargetResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanResultsAggregatedByTargetResourceResponse]
 */
public fun Inspector2Client.listCisScanResultsAggregatedByTargetResourcePaginated(initialRequest: ListCisScanResultsAggregatedByTargetResourceRequest): Flow<ListCisScanResultsAggregatedByTargetResourceResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCisScanResultsAggregatedByTargetResourcePaginated.listCisScanResultsAggregatedByTargetResource(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCisScanResultsAggregatedByTargetResourceResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScanResultsAggregatedByTargetResourceResponse]
 */
public fun Inspector2Client.listCisScanResultsAggregatedByTargetResourcePaginated(block: ListCisScanResultsAggregatedByTargetResourceRequest.Builder.() -> Unit): Flow<ListCisScanResultsAggregatedByTargetResourceResponse> =
    listCisScanResultsAggregatedByTargetResourcePaginated(ListCisScanResultsAggregatedByTargetResourceRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCisScanResultsAggregatedByTargetResourcePaginated]
 * to access the nested member [CisTargetResourceAggregation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CisTargetResourceAggregation]
 */
@JvmName("listCisScanResultsAggregatedByTargetResourceResponseCisTargetResourceAggregation")
public fun Flow<ListCisScanResultsAggregatedByTargetResourceResponse>.targetResourceAggregations(): Flow<CisTargetResourceAggregation> =
    transform() { response ->
        response.targetResourceAggregations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCisScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCisScansRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScansResponse]
 */
public fun Inspector2Client.listCisScansPaginated(initialRequest: ListCisScansRequest = ListCisScansRequest { }): Flow<ListCisScansResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCisScansPaginated.listCisScans(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCisScansResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCisScansResponse]
 */
public fun Inspector2Client.listCisScansPaginated(block: ListCisScansRequest.Builder.() -> Unit): Flow<ListCisScansResponse> =
    listCisScansPaginated(ListCisScansRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCisScansPaginated]
 * to access the nested member [CisScan]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CisScan]
 */
@JvmName("listCisScansResponseCisScan")
public fun Flow<ListCisScansResponse>.scans(): Flow<CisScan> =
    transform() { response ->
        response.scans?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoverageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageResponse]
 */
public fun Inspector2Client.listCoveragePaginated(initialRequest: ListCoverageRequest = ListCoverageRequest { }): Flow<ListCoverageResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoveragePaginated.listCoverage(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageResponse]
 */
public fun Inspector2Client.listCoveragePaginated(block: ListCoverageRequest.Builder.() -> Unit): Flow<ListCoverageResponse> =
    listCoveragePaginated(ListCoverageRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoveragePaginated]
 * to access the nested member [CoveredResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoveredResource]
 */
@JvmName("listCoverageResponseCoveredResource")
public fun Flow<ListCoverageResponse>.coveredResources(): Flow<CoveredResource> =
    transform() { response ->
        response.coveredResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoverageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoverageStatisticsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageStatisticsResponse]
 */
public fun Inspector2Client.listCoverageStatisticsPaginated(initialRequest: ListCoverageStatisticsRequest = ListCoverageStatisticsRequest { }): Flow<ListCoverageStatisticsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoverageStatisticsPaginated.listCoverageStatistics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoverageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageStatisticsResponse]
 */
public fun Inspector2Client.listCoverageStatisticsPaginated(block: ListCoverageStatisticsRequest.Builder.() -> Unit): Flow<ListCoverageStatisticsResponse> =
    listCoverageStatisticsPaginated(ListCoverageStatisticsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoverageStatisticsPaginated]
 * to access the nested member [Counts]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Counts]
 */
@JvmName("listCoverageStatisticsResponseCounts")
public fun Flow<ListCoverageStatisticsResponse>.countsByGroup(): Flow<Counts> =
    transform() { response ->
        response.countsByGroup?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDelegatedAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDelegatedAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdminAccountsResponse]
 */
public fun Inspector2Client.listDelegatedAdminAccountsPaginated(initialRequest: ListDelegatedAdminAccountsRequest = ListDelegatedAdminAccountsRequest { }): Flow<ListDelegatedAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDelegatedAdminAccountsPaginated.listDelegatedAdminAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDelegatedAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdminAccountsResponse]
 */
public fun Inspector2Client.listDelegatedAdminAccountsPaginated(block: ListDelegatedAdminAccountsRequest.Builder.() -> Unit): Flow<ListDelegatedAdminAccountsResponse> =
    listDelegatedAdminAccountsPaginated(ListDelegatedAdminAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDelegatedAdminAccountsPaginated]
 * to access the nested member [DelegatedAdminAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DelegatedAdminAccount]
 */
@JvmName("listDelegatedAdminAccountsResponseDelegatedAdminAccount")
public fun Flow<ListDelegatedAdminAccountsResponse>.delegatedAdminAccounts(): Flow<DelegatedAdminAccount> =
    transform() { response ->
        response.delegatedAdminAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun Inspector2Client.listFiltersPaginated(initialRequest: ListFiltersRequest = ListFiltersRequest { }): Flow<ListFiltersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFiltersPaginated.listFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun Inspector2Client.listFiltersPaginated(block: ListFiltersRequest.Builder.() -> Unit): Flow<ListFiltersResponse> =
    listFiltersPaginated(ListFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFiltersPaginated]
 * to access the nested member [Filter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Filter]
 */
@JvmName("listFiltersResponseFilter")
public fun Flow<ListFiltersResponse>.filters(): Flow<Filter> =
    transform() { response ->
        response.filters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingAggregationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregationsResponse]
 */
public fun Inspector2Client.listFindingAggregationsPaginated(initialRequest: ListFindingAggregationsRequest): Flow<ListFindingAggregationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingAggregationsPaginated.listFindingAggregations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregationsResponse]
 */
public fun Inspector2Client.listFindingAggregationsPaginated(block: ListFindingAggregationsRequest.Builder.() -> Unit): Flow<ListFindingAggregationsResponse> =
    listFindingAggregationsPaginated(ListFindingAggregationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingAggregationsPaginated]
 * to access the nested member [AggregationResponse]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AggregationResponse]
 */
@JvmName("listFindingAggregationsResponseAggregationResponse")
public fun Flow<ListFindingAggregationsResponse>.responses(): Flow<AggregationResponse> =
    transform() { response ->
        response.responses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Inspector2Client.listFindingsPaginated(initialRequest: ListFindingsRequest = ListFindingsRequest { }): Flow<ListFindingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsPaginated.listFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Inspector2Client.listFindingsPaginated(block: ListFindingsRequest.Builder.() -> Unit): Flow<ListFindingsResponse> =
    listFindingsPaginated(ListFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsPaginated]
 * to access the nested member [Finding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Finding]
 */
@JvmName("listFindingsResponseFinding")
public fun Flow<ListFindingsResponse>.findings(): Flow<Finding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Inspector2Client.listMembersPaginated(initialRequest: ListMembersRequest = ListMembersRequest { }): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Inspector2Client.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersPaginated]
 * to access the nested member [Member]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Member]
 */
@JvmName("listMembersResponseMember")
public fun Flow<ListMembersResponse>.members(): Flow<Member> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsageTotalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsageTotalsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsageTotalsResponse]
 */
public fun Inspector2Client.listUsageTotalsPaginated(initialRequest: ListUsageTotalsRequest = ListUsageTotalsRequest { }): Flow<ListUsageTotalsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsageTotalsPaginated.listUsageTotals(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsageTotalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsageTotalsResponse]
 */
public fun Inspector2Client.listUsageTotalsPaginated(block: ListUsageTotalsRequest.Builder.() -> Unit): Flow<ListUsageTotalsResponse> =
    listUsageTotalsPaginated(ListUsageTotalsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsageTotalsPaginated]
 * to access the nested member [UsageTotal]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsageTotal]
 */
@JvmName("listUsageTotalsResponseUsageTotal")
public fun Flow<ListUsageTotalsResponse>.totals(): Flow<UsageTotal> =
    transform() { response ->
        response.totals?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchVulnerabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchVulnerabilitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVulnerabilitiesResponse]
 */
public fun Inspector2Client.searchVulnerabilitiesPaginated(initialRequest: SearchVulnerabilitiesRequest): Flow<SearchVulnerabilitiesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchVulnerabilitiesPaginated.searchVulnerabilities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchVulnerabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVulnerabilitiesResponse]
 */
public fun Inspector2Client.searchVulnerabilitiesPaginated(block: SearchVulnerabilitiesRequest.Builder.() -> Unit): Flow<SearchVulnerabilitiesResponse> =
    searchVulnerabilitiesPaginated(SearchVulnerabilitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchVulnerabilitiesPaginated]
 * to access the nested member [Vulnerability]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Vulnerability]
 */
@JvmName("searchVulnerabilitiesResponseVulnerability")
public fun Flow<SearchVulnerabilitiesResponse>.vulnerabilities(): Flow<Vulnerability> =
    transform() { response ->
        response.vulnerabilities?.forEach {
            emit(it)
        }
    }
