// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.inspector2.auth.DefaultInspector2AuthSchemeProvider
import aws.sdk.kotlin.services.inspector2.auth.Inspector2AuthSchemeProvider
import aws.sdk.kotlin.services.inspector2.endpoints.DefaultInspector2EndpointProvider
import aws.sdk.kotlin.services.inspector2.endpoints.Inspector2EndpointParameters
import aws.sdk.kotlin.services.inspector2.endpoints.Inspector2EndpointProvider
import aws.sdk.kotlin.services.inspector2.model.AssociateMemberRequest
import aws.sdk.kotlin.services.inspector2.model.AssociateMemberResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetAccountStatusRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetAccountStatusResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetCodeSnippetRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetCodeSnippetResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetFindingDetailsRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetFindingDetailsResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetFreeTrialInfoRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetFreeTrialInfoResponse
import aws.sdk.kotlin.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusRequest
import aws.sdk.kotlin.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse
import aws.sdk.kotlin.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusRequest
import aws.sdk.kotlin.services.inspector2.model.BatchUpdateMemberEc2DeepInspectionStatusResponse
import aws.sdk.kotlin.services.inspector2.model.CancelFindingsReportRequest
import aws.sdk.kotlin.services.inspector2.model.CancelFindingsReportResponse
import aws.sdk.kotlin.services.inspector2.model.CancelSbomExportRequest
import aws.sdk.kotlin.services.inspector2.model.CancelSbomExportResponse
import aws.sdk.kotlin.services.inspector2.model.CreateCisScanConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.CreateCisScanConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.CreateFilterRequest
import aws.sdk.kotlin.services.inspector2.model.CreateFilterResponse
import aws.sdk.kotlin.services.inspector2.model.CreateFindingsReportRequest
import aws.sdk.kotlin.services.inspector2.model.CreateFindingsReportResponse
import aws.sdk.kotlin.services.inspector2.model.CreateSbomExportRequest
import aws.sdk.kotlin.services.inspector2.model.CreateSbomExportResponse
import aws.sdk.kotlin.services.inspector2.model.DeleteCisScanConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.DeleteCisScanConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.DeleteFilterRequest
import aws.sdk.kotlin.services.inspector2.model.DeleteFilterResponse
import aws.sdk.kotlin.services.inspector2.model.DescribeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.DisableDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.DisableDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.DisableRequest
import aws.sdk.kotlin.services.inspector2.model.DisableResponse
import aws.sdk.kotlin.services.inspector2.model.DisassociateMemberRequest
import aws.sdk.kotlin.services.inspector2.model.DisassociateMemberResponse
import aws.sdk.kotlin.services.inspector2.model.EnableDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.EnableDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.EnableRequest
import aws.sdk.kotlin.services.inspector2.model.EnableResponse
import aws.sdk.kotlin.services.inspector2.model.GetCisScanReportRequest
import aws.sdk.kotlin.services.inspector2.model.GetCisScanReportResponse
import aws.sdk.kotlin.services.inspector2.model.GetCisScanResultDetailsRequest
import aws.sdk.kotlin.services.inspector2.model.GetCisScanResultDetailsResponse
import aws.sdk.kotlin.services.inspector2.model.GetConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.GetConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.GetDelegatedAdminAccountRequest
import aws.sdk.kotlin.services.inspector2.model.GetDelegatedAdminAccountResponse
import aws.sdk.kotlin.services.inspector2.model.GetEc2DeepInspectionConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.GetEc2DeepInspectionConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.GetEncryptionKeyRequest
import aws.sdk.kotlin.services.inspector2.model.GetEncryptionKeyResponse
import aws.sdk.kotlin.services.inspector2.model.GetFindingsReportStatusRequest
import aws.sdk.kotlin.services.inspector2.model.GetFindingsReportStatusResponse
import aws.sdk.kotlin.services.inspector2.model.GetMemberRequest
import aws.sdk.kotlin.services.inspector2.model.GetMemberResponse
import aws.sdk.kotlin.services.inspector2.model.GetSbomExportRequest
import aws.sdk.kotlin.services.inspector2.model.GetSbomExportResponse
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsRequest
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanConfigurationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanConfigurationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByChecksRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByChecksResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScanResultsAggregatedByTargetResourceResponse
import aws.sdk.kotlin.services.inspector2.model.ListCisScansRequest
import aws.sdk.kotlin.services.inspector2.model.ListCisScansResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsResponse
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsRequest
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFiltersRequest
import aws.sdk.kotlin.services.inspector2.model.ListFiltersResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector2.model.ListMembersRequest
import aws.sdk.kotlin.services.inspector2.model.ListMembersResponse
import aws.sdk.kotlin.services.inspector2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.inspector2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsRequest
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsResponse
import aws.sdk.kotlin.services.inspector2.model.ResetEncryptionKeyRequest
import aws.sdk.kotlin.services.inspector2.model.ResetEncryptionKeyResponse
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesRequest
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesResponse
import aws.sdk.kotlin.services.inspector2.model.SendCisSessionHealthRequest
import aws.sdk.kotlin.services.inspector2.model.SendCisSessionHealthResponse
import aws.sdk.kotlin.services.inspector2.model.SendCisSessionTelemetryRequest
import aws.sdk.kotlin.services.inspector2.model.SendCisSessionTelemetryResponse
import aws.sdk.kotlin.services.inspector2.model.StartCisSessionRequest
import aws.sdk.kotlin.services.inspector2.model.StartCisSessionResponse
import aws.sdk.kotlin.services.inspector2.model.StopCisSessionRequest
import aws.sdk.kotlin.services.inspector2.model.StopCisSessionResponse
import aws.sdk.kotlin.services.inspector2.model.TagResourceRequest
import aws.sdk.kotlin.services.inspector2.model.TagResourceResponse
import aws.sdk.kotlin.services.inspector2.model.UntagResourceRequest
import aws.sdk.kotlin.services.inspector2.model.UntagResourceResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateCisScanConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateCisScanConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateEc2DeepInspectionConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateEc2DeepInspectionConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateEncryptionKeyRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateEncryptionKeyResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateFilterRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateFilterResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.UpdateOrganizationConfigurationRequest
import aws.sdk.kotlin.services.inspector2.model.UpdateOrganizationConfigurationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Inspector2"
public const val SdkVersion: String = "1.3.17"
public const val ServiceApiVersion: String = "2020-06-08"

/**
 * Amazon Inspector is a vulnerability discovery service that automates continuous scanning for security vulnerabilities within your Amazon EC2, Amazon ECR, and Amazon Web Services Lambda environments.
 */
public interface Inspector2Client : SdkClient {
    /**
     * Inspector2Client's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, Inspector2Client, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Inspector2",
                "INSPECTOR2",
                "inspector2",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, Inspector2Client>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): Inspector2Client = DefaultInspector2Client(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: Inspector2EndpointProvider = builder.endpointProvider ?: DefaultInspector2EndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: Inspector2AuthSchemeProvider = builder.authSchemeProvider ?: DefaultInspector2AuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Inspector2"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: Inspector2EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: Inspector2AuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check if the association completed by using [ListMembers](https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html) for multiple accounts or [GetMembers](https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html) for a single account.
     */
    public suspend fun associateMember(input: AssociateMemberRequest): AssociateMemberResponse

    /**
     * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
     */
    public suspend fun batchGetAccountStatus(input: BatchGetAccountStatusRequest = BatchGetAccountStatusRequest { }): BatchGetAccountStatusResponse

    /**
     * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
     */
    public suspend fun batchGetCodeSnippet(input: BatchGetCodeSnippetRequest): BatchGetCodeSnippetResponse

    /**
     * Gets vulnerability details for findings.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.BatchGetFindingDetails.sample
     */
    public suspend fun batchGetFindingDetails(input: BatchGetFindingDetailsRequest): BatchGetFindingDetailsResponse

    /**
     * Gets free trial status for multiple Amazon Web Services accounts.
     */
    public suspend fun batchGetFreeTrialInfo(input: BatchGetFreeTrialInfoRequest): BatchGetFreeTrialInfoResponse

    /**
     * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     */
    public suspend fun batchGetMemberEc2DeepInspectionStatus(input: BatchGetMemberEc2DeepInspectionStatusRequest = BatchGetMemberEc2DeepInspectionStatusRequest { }): BatchGetMemberEc2DeepInspectionStatusResponse

    /**
     * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
     */
    public suspend fun batchUpdateMemberEc2DeepInspectionStatus(input: BatchUpdateMemberEc2DeepInspectionStatusRequest): BatchUpdateMemberEc2DeepInspectionStatusResponse

    /**
     * Cancels the given findings report.
     */
    public suspend fun cancelFindingsReport(input: CancelFindingsReportRequest): CancelFindingsReportResponse

    /**
     * Cancels a software bill of materials (SBOM) report.
     */
    public suspend fun cancelSbomExport(input: CancelSbomExportRequest): CancelSbomExportResponse

    /**
     * Creates a CIS scan configuration.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.CreateCisScanConfiguration.sample
     */
    public suspend fun createCisScanConfiguration(input: CreateCisScanConfigurationRequest): CreateCisScanConfigurationResponse

    /**
     * Creates a filter resource using specified filter criteria. When the filter action is set to `SUPPRESS` this action creates a suppression rule.
     */
    public suspend fun createFilter(input: CreateFilterRequest): CreateFilterResponse

    /**
     * Creates a finding report. By default only `ACTIVE` findings are returned in the report. To see `SUPRESSED` or `CLOSED` findings you must specify a value for the `findingStatus` filter criteria.
     */
    public suspend fun createFindingsReport(input: CreateFindingsReportRequest): CreateFindingsReportResponse

    /**
     * Creates a software bill of materials (SBOM) report.
     */
    public suspend fun createSbomExport(input: CreateSbomExportRequest): CreateSbomExportResponse

    /**
     * Deletes a CIS scan configuration.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.DeleteCisScanConfiguration.sample
     */
    public suspend fun deleteCisScanConfiguration(input: DeleteCisScanConfigurationRequest): DeleteCisScanConfigurationResponse

    /**
     * Deletes a filter resource.
     */
    public suspend fun deleteFilter(input: DeleteFilterRequest): DeleteFilterResponse

    /**
     * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
     */
    public suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest = DescribeOrganizationConfigurationRequest { }): DescribeOrganizationConfigurationResponse

    /**
     * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
     */
    public suspend fun disable(input: DisableRequest = DisableRequest { }): DisableResponse

    /**
     * Disables the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun disableDelegatedAdminAccount(input: DisableDelegatedAdminAccountRequest): DisableDelegatedAdminAccountResponse

    /**
     * Disassociates a member account from an Amazon Inspector delegated administrator.
     */
    public suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse

    /**
     * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
     */
    public suspend fun enable(input: EnableRequest): EnableResponse

    /**
     * Enables the Amazon Inspector delegated administrator for your Organizations organization.
     */
    public suspend fun enableDelegatedAdminAccount(input: EnableDelegatedAdminAccountRequest): EnableDelegatedAdminAccountResponse

    /**
     * Retrieves a CIS scan report.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.GetCisScanReport.sample
     */
    public suspend fun getCisScanReport(input: GetCisScanReportRequest): GetCisScanReportResponse

    /**
     * Retrieves CIS scan result details.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.GetCisScanResultDetails.sample
     */
    public suspend fun getCisScanResultDetails(input: GetCisScanResultDetailsRequest): GetCisScanResultDetailsResponse

    /**
     * Retrieves setting configurations for Inspector scans.
     */
    public suspend fun getConfiguration(input: GetConfigurationRequest = GetConfigurationRequest { }): GetConfigurationResponse

    /**
     * Retrieves information about the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun getDelegatedAdminAccount(input: GetDelegatedAdminAccountRequest = GetDelegatedAdminAccountRequest { }): GetDelegatedAdminAccountResponse

    /**
     * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your account.
     */
    public suspend fun getEc2DeepInspectionConfiguration(input: GetEc2DeepInspectionConfigurationRequest = GetEc2DeepInspectionConfigurationRequest { }): GetEc2DeepInspectionConfigurationResponse

    /**
     * Gets an encryption key.
     */
    public suspend fun getEncryptionKey(input: GetEncryptionKeyRequest): GetEncryptionKeyResponse

    /**
     * Gets the status of a findings report.
     */
    public suspend fun getFindingsReportStatus(input: GetFindingsReportStatusRequest = GetFindingsReportStatusRequest { }): GetFindingsReportStatusResponse

    /**
     * Gets member information for your organization.
     */
    public suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Gets details of a software bill of materials (SBOM) report.
     */
    public suspend fun getSbomExport(input: GetSbomExportRequest): GetSbomExportResponse

    /**
     * Lists the permissions an account has to configure Amazon Inspector.
     */
    public suspend fun listAccountPermissions(input: ListAccountPermissionsRequest = ListAccountPermissionsRequest { }): ListAccountPermissionsResponse

    /**
     * Lists CIS scan configurations.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanConfigurations.sample
     */
    public suspend fun listCisScanConfigurations(input: ListCisScanConfigurationsRequest = ListCisScanConfigurationsRequest { }): ListCisScanConfigurationsResponse

    /**
     * Lists scan results aggregated by checks.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanResultsAggregatedByChecks.sample
     */
    public suspend fun listCisScanResultsAggregatedByChecks(input: ListCisScanResultsAggregatedByChecksRequest): ListCisScanResultsAggregatedByChecksResponse

    /**
     * Lists scan results aggregated by a target resource.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanResultsAggregatedByTargetResource.sample
     */
    public suspend fun listCisScanResultsAggregatedByTargetResource(input: ListCisScanResultsAggregatedByTargetResourceRequest): ListCisScanResultsAggregatedByTargetResourceResponse

    /**
     * Returns a CIS scan list.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScans.sample
     */
    public suspend fun listCisScans(input: ListCisScansRequest = ListCisScansRequest { }): ListCisScansResponse

    /**
     * Lists coverage details for you environment.
     */
    public suspend fun listCoverage(input: ListCoverageRequest = ListCoverageRequest { }): ListCoverageResponse

    /**
     * Lists Amazon Inspector coverage statistics for your environment.
     */
    public suspend fun listCoverageStatistics(input: ListCoverageStatisticsRequest = ListCoverageStatisticsRequest { }): ListCoverageStatisticsResponse

    /**
     * Lists information about the Amazon Inspector delegated administrator of your organization.
     */
    public suspend fun listDelegatedAdminAccounts(input: ListDelegatedAdminAccountsRequest = ListDelegatedAdminAccountsRequest { }): ListDelegatedAdminAccountsResponse

    /**
     * Lists the filters associated with your account.
     */
    public suspend fun listFilters(input: ListFiltersRequest = ListFiltersRequest { }): ListFiltersResponse

    /**
     * Lists aggregated finding data for your environment based on specific criteria.
     */
    public suspend fun listFindingAggregations(input: ListFindingAggregationsRequest): ListFindingAggregationsResponse

    /**
     * Lists findings for your environment.
     */
    public suspend fun listFindings(input: ListFindingsRequest = ListFindingsRequest { }): ListFindingsResponse

    /**
     * List members associated with the Amazon Inspector delegated administrator for your organization.
     */
    public suspend fun listMembers(input: ListMembersRequest = ListMembersRequest { }): ListMembersResponse

    /**
     * Lists all tags attached to a given resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the Amazon Inspector usage totals over the last 30 days.
     */
    public suspend fun listUsageTotals(input: ListUsageTotalsRequest = ListUsageTotalsRequest { }): ListUsageTotalsResponse

    /**
     * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned key.
     */
    public suspend fun resetEncryptionKey(input: ResetEncryptionKeyRequest): ResetEncryptionKeyResponse

    /**
     * Lists Amazon Inspector coverage details for a specific vulnerability.
     */
    public suspend fun searchVulnerabilities(input: SearchVulnerabilitiesRequest): SearchVulnerabilitiesResponse

    /**
     * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.SendCisSessionHealth.sample
     */
    public suspend fun sendCisSessionHealth(input: SendCisSessionHealthRequest): SendCisSessionHealthResponse

    /**
     * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.SendCisSessionTelemetry.sample
     */
    public suspend fun sendCisSessionTelemetry(input: SendCisSessionTelemetryRequest): SendCisSessionTelemetryResponse

    /**
     * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.StartCisSession.sample
     */
    public suspend fun startCisSession(input: StartCisSessionRequest): StartCisSessionResponse

    /**
     * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.StopCisSession.sample
     */
    public suspend fun stopCisSession(input: StopCisSessionRequest): StopCisSessionResponse

    /**
     * Adds tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a CIS scan configuration.
     *
     * @sample aws.sdk.kotlin.services.inspector2.samples.UpdateCisScanConfiguration.sample
     */
    public suspend fun updateCisScanConfiguration(input: UpdateCisScanConfigurationRequest): UpdateCisScanConfigurationResponse

    /**
     * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
     */
    public suspend fun updateConfiguration(input: UpdateConfigurationRequest = UpdateConfigurationRequest { }): UpdateConfigurationResponse

    /**
     * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
     */
    public suspend fun updateEc2DeepInspectionConfiguration(input: UpdateEc2DeepInspectionConfigurationRequest = UpdateEc2DeepInspectionConfigurationRequest { }): UpdateEc2DeepInspectionConfigurationResponse

    /**
     * Updates an encryption key. A `ResourceNotFoundException` means that an Amazon Web Services owned key is being used for encryption.
     */
    public suspend fun updateEncryptionKey(input: UpdateEncryptionKeyRequest): UpdateEncryptionKeyResponse

    /**
     * Specifies the action that is to be applied to the findings that match the filter.
     */
    public suspend fun updateFilter(input: UpdateFilterRequest): UpdateFilterResponse

    /**
     * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector delegated administrator to use this API.
     */
    public suspend fun updateOrgEc2DeepInspectionConfiguration(input: UpdateOrgEc2DeepInspectionConfigurationRequest): UpdateOrgEc2DeepInspectionConfigurationResponse

    /**
     * Updates the configurations for your Amazon Inspector organization.
     */
    public suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun Inspector2Client.withConfig(block: Inspector2Client.Config.Builder.() -> Unit): Inspector2Client {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultInspector2Client(newConfig)
}

/**
 * Associates an Amazon Web Services account with an Amazon Inspector delegated administrator. An HTTP 200 response indicates the association was successfully started, but doesn’t indicate whether it was completed. You can check if the association completed by using [ListMembers](https://docs.aws.amazon.com/inspector/v2/APIReference/API_ListMembers.html) for multiple accounts or [GetMembers](https://docs.aws.amazon.com/inspector/v2/APIReference/API_GetMember.html) for a single account.
 */
public suspend inline fun Inspector2Client.associateMember(crossinline block: AssociateMemberRequest.Builder.() -> Unit): AssociateMemberResponse = associateMember(AssociateMemberRequest.Builder().apply(block).build())

/**
 * Retrieves the Amazon Inspector status of multiple Amazon Web Services accounts within your environment.
 */
public suspend inline fun Inspector2Client.batchGetAccountStatus(crossinline block: BatchGetAccountStatusRequest.Builder.() -> Unit): BatchGetAccountStatusResponse = batchGetAccountStatus(BatchGetAccountStatusRequest.Builder().apply(block).build())

/**
 * Retrieves code snippets from findings that Amazon Inspector detected code vulnerabilities in.
 */
public suspend inline fun Inspector2Client.batchGetCodeSnippet(crossinline block: BatchGetCodeSnippetRequest.Builder.() -> Unit): BatchGetCodeSnippetResponse = batchGetCodeSnippet(BatchGetCodeSnippetRequest.Builder().apply(block).build())

/**
 * Gets vulnerability details for findings.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.BatchGetFindingDetails.sample
 */
public suspend inline fun Inspector2Client.batchGetFindingDetails(crossinline block: BatchGetFindingDetailsRequest.Builder.() -> Unit): BatchGetFindingDetailsResponse = batchGetFindingDetails(BatchGetFindingDetailsRequest.Builder().apply(block).build())

/**
 * Gets free trial status for multiple Amazon Web Services accounts.
 */
public suspend inline fun Inspector2Client.batchGetFreeTrialInfo(crossinline block: BatchGetFreeTrialInfoRequest.Builder.() -> Unit): BatchGetFreeTrialInfoResponse = batchGetFreeTrialInfo(BatchGetFreeTrialInfoRequest.Builder().apply(block).build())

/**
 * Retrieves Amazon Inspector deep inspection activation status of multiple member accounts within your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
 */
public suspend inline fun Inspector2Client.batchGetMemberEc2DeepInspectionStatus(crossinline block: BatchGetMemberEc2DeepInspectionStatusRequest.Builder.() -> Unit): BatchGetMemberEc2DeepInspectionStatusResponse = batchGetMemberEc2DeepInspectionStatus(BatchGetMemberEc2DeepInspectionStatusRequest.Builder().apply(block).build())

/**
 * Activates or deactivates Amazon Inspector deep inspection for the provided member accounts in your organization. You must be the delegated administrator of an organization in Amazon Inspector to use this API.
 */
public suspend inline fun Inspector2Client.batchUpdateMemberEc2DeepInspectionStatus(crossinline block: BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder.() -> Unit): BatchUpdateMemberEc2DeepInspectionStatusResponse = batchUpdateMemberEc2DeepInspectionStatus(BatchUpdateMemberEc2DeepInspectionStatusRequest.Builder().apply(block).build())

/**
 * Cancels the given findings report.
 */
public suspend inline fun Inspector2Client.cancelFindingsReport(crossinline block: CancelFindingsReportRequest.Builder.() -> Unit): CancelFindingsReportResponse = cancelFindingsReport(CancelFindingsReportRequest.Builder().apply(block).build())

/**
 * Cancels a software bill of materials (SBOM) report.
 */
public suspend inline fun Inspector2Client.cancelSbomExport(crossinline block: CancelSbomExportRequest.Builder.() -> Unit): CancelSbomExportResponse = cancelSbomExport(CancelSbomExportRequest.Builder().apply(block).build())

/**
 * Creates a CIS scan configuration.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.CreateCisScanConfiguration.sample
 */
public suspend inline fun Inspector2Client.createCisScanConfiguration(crossinline block: CreateCisScanConfigurationRequest.Builder.() -> Unit): CreateCisScanConfigurationResponse = createCisScanConfiguration(CreateCisScanConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a filter resource using specified filter criteria. When the filter action is set to `SUPPRESS` this action creates a suppression rule.
 */
public suspend inline fun Inspector2Client.createFilter(crossinline block: CreateFilterRequest.Builder.() -> Unit): CreateFilterResponse = createFilter(CreateFilterRequest.Builder().apply(block).build())

/**
 * Creates a finding report. By default only `ACTIVE` findings are returned in the report. To see `SUPRESSED` or `CLOSED` findings you must specify a value for the `findingStatus` filter criteria.
 */
public suspend inline fun Inspector2Client.createFindingsReport(crossinline block: CreateFindingsReportRequest.Builder.() -> Unit): CreateFindingsReportResponse = createFindingsReport(CreateFindingsReportRequest.Builder().apply(block).build())

/**
 * Creates a software bill of materials (SBOM) report.
 */
public suspend inline fun Inspector2Client.createSbomExport(crossinline block: CreateSbomExportRequest.Builder.() -> Unit): CreateSbomExportResponse = createSbomExport(CreateSbomExportRequest.Builder().apply(block).build())

/**
 * Deletes a CIS scan configuration.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.DeleteCisScanConfiguration.sample
 */
public suspend inline fun Inspector2Client.deleteCisScanConfiguration(crossinline block: DeleteCisScanConfigurationRequest.Builder.() -> Unit): DeleteCisScanConfigurationResponse = deleteCisScanConfiguration(DeleteCisScanConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes a filter resource.
 */
public suspend inline fun Inspector2Client.deleteFilter(crossinline block: DeleteFilterRequest.Builder.() -> Unit): DeleteFilterResponse = deleteFilter(DeleteFilterRequest.Builder().apply(block).build())

/**
 * Describe Amazon Inspector configuration settings for an Amazon Web Services organization.
 */
public suspend inline fun Inspector2Client.describeOrganizationConfiguration(crossinline block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit): DescribeOrganizationConfigurationResponse = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Disables Amazon Inspector scans for one or more Amazon Web Services accounts. Disabling all scan types in an account disables the Amazon Inspector service.
 */
public suspend inline fun Inspector2Client.disable(crossinline block: DisableRequest.Builder.() -> Unit): DisableResponse = disable(DisableRequest.Builder().apply(block).build())

/**
 * Disables the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.disableDelegatedAdminAccount(crossinline block: DisableDelegatedAdminAccountRequest.Builder.() -> Unit): DisableDelegatedAdminAccountResponse = disableDelegatedAdminAccount(DisableDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Disassociates a member account from an Amazon Inspector delegated administrator.
 */
public suspend inline fun Inspector2Client.disassociateMember(crossinline block: DisassociateMemberRequest.Builder.() -> Unit): DisassociateMemberResponse = disassociateMember(DisassociateMemberRequest.Builder().apply(block).build())

/**
 * Enables Amazon Inspector scans for one or more Amazon Web Services accounts.
 */
public suspend inline fun Inspector2Client.enable(crossinline block: EnableRequest.Builder.() -> Unit): EnableResponse = enable(EnableRequest.Builder().apply(block).build())

/**
 * Enables the Amazon Inspector delegated administrator for your Organizations organization.
 */
public suspend inline fun Inspector2Client.enableDelegatedAdminAccount(crossinline block: EnableDelegatedAdminAccountRequest.Builder.() -> Unit): EnableDelegatedAdminAccountResponse = enableDelegatedAdminAccount(EnableDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Retrieves a CIS scan report.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.GetCisScanReport.sample
 */
public suspend inline fun Inspector2Client.getCisScanReport(crossinline block: GetCisScanReportRequest.Builder.() -> Unit): GetCisScanReportResponse = getCisScanReport(GetCisScanReportRequest.Builder().apply(block).build())

/**
 * Retrieves CIS scan result details.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.GetCisScanResultDetails.sample
 */
public suspend inline fun Inspector2Client.getCisScanResultDetails(crossinline block: GetCisScanResultDetailsRequest.Builder.() -> Unit): GetCisScanResultDetailsResponse = getCisScanResultDetails(GetCisScanResultDetailsRequest.Builder().apply(block).build())

/**
 * Retrieves setting configurations for Inspector scans.
 */
public suspend inline fun Inspector2Client.getConfiguration(crossinline block: GetConfigurationRequest.Builder.() -> Unit): GetConfigurationResponse = getConfiguration(GetConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.getDelegatedAdminAccount(crossinline block: GetDelegatedAdminAccountRequest.Builder.() -> Unit): GetDelegatedAdminAccountResponse = getDelegatedAdminAccount(GetDelegatedAdminAccountRequest.Builder().apply(block).build())

/**
 * Retrieves the activation status of Amazon Inspector deep inspection and custom paths associated with your account.
 */
public suspend inline fun Inspector2Client.getEc2DeepInspectionConfiguration(crossinline block: GetEc2DeepInspectionConfigurationRequest.Builder.() -> Unit): GetEc2DeepInspectionConfigurationResponse = getEc2DeepInspectionConfiguration(GetEc2DeepInspectionConfigurationRequest.Builder().apply(block).build())

/**
 * Gets an encryption key.
 */
public suspend inline fun Inspector2Client.getEncryptionKey(crossinline block: GetEncryptionKeyRequest.Builder.() -> Unit): GetEncryptionKeyResponse = getEncryptionKey(GetEncryptionKeyRequest.Builder().apply(block).build())

/**
 * Gets the status of a findings report.
 */
public suspend inline fun Inspector2Client.getFindingsReportStatus(crossinline block: GetFindingsReportStatusRequest.Builder.() -> Unit): GetFindingsReportStatusResponse = getFindingsReportStatus(GetFindingsReportStatusRequest.Builder().apply(block).build())

/**
 * Gets member information for your organization.
 */
public suspend inline fun Inspector2Client.getMember(crossinline block: GetMemberRequest.Builder.() -> Unit): GetMemberResponse = getMember(GetMemberRequest.Builder().apply(block).build())

/**
 * Gets details of a software bill of materials (SBOM) report.
 */
public suspend inline fun Inspector2Client.getSbomExport(crossinline block: GetSbomExportRequest.Builder.() -> Unit): GetSbomExportResponse = getSbomExport(GetSbomExportRequest.Builder().apply(block).build())

/**
 * Lists the permissions an account has to configure Amazon Inspector.
 */
public suspend inline fun Inspector2Client.listAccountPermissions(crossinline block: ListAccountPermissionsRequest.Builder.() -> Unit): ListAccountPermissionsResponse = listAccountPermissions(ListAccountPermissionsRequest.Builder().apply(block).build())

/**
 * Lists CIS scan configurations.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanConfigurations.sample
 */
public suspend inline fun Inspector2Client.listCisScanConfigurations(crossinline block: ListCisScanConfigurationsRequest.Builder.() -> Unit): ListCisScanConfigurationsResponse = listCisScanConfigurations(ListCisScanConfigurationsRequest.Builder().apply(block).build())

/**
 * Lists scan results aggregated by checks.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanResultsAggregatedByChecks.sample
 */
public suspend inline fun Inspector2Client.listCisScanResultsAggregatedByChecks(crossinline block: ListCisScanResultsAggregatedByChecksRequest.Builder.() -> Unit): ListCisScanResultsAggregatedByChecksResponse = listCisScanResultsAggregatedByChecks(ListCisScanResultsAggregatedByChecksRequest.Builder().apply(block).build())

/**
 * Lists scan results aggregated by a target resource.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScanResultsAggregatedByTargetResource.sample
 */
public suspend inline fun Inspector2Client.listCisScanResultsAggregatedByTargetResource(crossinline block: ListCisScanResultsAggregatedByTargetResourceRequest.Builder.() -> Unit): ListCisScanResultsAggregatedByTargetResourceResponse = listCisScanResultsAggregatedByTargetResource(ListCisScanResultsAggregatedByTargetResourceRequest.Builder().apply(block).build())

/**
 * Returns a CIS scan list.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.ListCisScans.sample
 */
public suspend inline fun Inspector2Client.listCisScans(crossinline block: ListCisScansRequest.Builder.() -> Unit): ListCisScansResponse = listCisScans(ListCisScansRequest.Builder().apply(block).build())

/**
 * Lists coverage details for you environment.
 */
public suspend inline fun Inspector2Client.listCoverage(crossinline block: ListCoverageRequest.Builder.() -> Unit): ListCoverageResponse = listCoverage(ListCoverageRequest.Builder().apply(block).build())

/**
 * Lists Amazon Inspector coverage statistics for your environment.
 */
public suspend inline fun Inspector2Client.listCoverageStatistics(crossinline block: ListCoverageStatisticsRequest.Builder.() -> Unit): ListCoverageStatisticsResponse = listCoverageStatistics(ListCoverageStatisticsRequest.Builder().apply(block).build())

/**
 * Lists information about the Amazon Inspector delegated administrator of your organization.
 */
public suspend inline fun Inspector2Client.listDelegatedAdminAccounts(crossinline block: ListDelegatedAdminAccountsRequest.Builder.() -> Unit): ListDelegatedAdminAccountsResponse = listDelegatedAdminAccounts(ListDelegatedAdminAccountsRequest.Builder().apply(block).build())

/**
 * Lists the filters associated with your account.
 */
public suspend inline fun Inspector2Client.listFilters(crossinline block: ListFiltersRequest.Builder.() -> Unit): ListFiltersResponse = listFilters(ListFiltersRequest.Builder().apply(block).build())

/**
 * Lists aggregated finding data for your environment based on specific criteria.
 */
public suspend inline fun Inspector2Client.listFindingAggregations(crossinline block: ListFindingAggregationsRequest.Builder.() -> Unit): ListFindingAggregationsResponse = listFindingAggregations(ListFindingAggregationsRequest.Builder().apply(block).build())

/**
 * Lists findings for your environment.
 */
public suspend inline fun Inspector2Client.listFindings(crossinline block: ListFindingsRequest.Builder.() -> Unit): ListFindingsResponse = listFindings(ListFindingsRequest.Builder().apply(block).build())

/**
 * List members associated with the Amazon Inspector delegated administrator for your organization.
 */
public suspend inline fun Inspector2Client.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Lists all tags attached to a given resource.
 */
public suspend inline fun Inspector2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the Amazon Inspector usage totals over the last 30 days.
 */
public suspend inline fun Inspector2Client.listUsageTotals(crossinline block: ListUsageTotalsRequest.Builder.() -> Unit): ListUsageTotalsResponse = listUsageTotals(ListUsageTotalsRequest.Builder().apply(block).build())

/**
 * Resets an encryption key. After the key is reset your resources will be encrypted by an Amazon Web Services owned key.
 */
public suspend inline fun Inspector2Client.resetEncryptionKey(crossinline block: ResetEncryptionKeyRequest.Builder.() -> Unit): ResetEncryptionKeyResponse = resetEncryptionKey(ResetEncryptionKeyRequest.Builder().apply(block).build())

/**
 * Lists Amazon Inspector coverage details for a specific vulnerability.
 */
public suspend inline fun Inspector2Client.searchVulnerabilities(crossinline block: SearchVulnerabilitiesRequest.Builder.() -> Unit): SearchVulnerabilitiesResponse = searchVulnerabilities(SearchVulnerabilitiesRequest.Builder().apply(block).build())

/**
 * Sends a CIS session health. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.SendCisSessionHealth.sample
 */
public suspend inline fun Inspector2Client.sendCisSessionHealth(crossinline block: SendCisSessionHealthRequest.Builder.() -> Unit): SendCisSessionHealthResponse = sendCisSessionHealth(SendCisSessionHealthRequest.Builder().apply(block).build())

/**
 * Sends a CIS session telemetry. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.SendCisSessionTelemetry.sample
 */
public suspend inline fun Inspector2Client.sendCisSessionTelemetry(crossinline block: SendCisSessionTelemetryRequest.Builder.() -> Unit): SendCisSessionTelemetryResponse = sendCisSessionTelemetry(SendCisSessionTelemetryRequest.Builder().apply(block).build())

/**
 * Starts a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.StartCisSession.sample
 */
public suspend inline fun Inspector2Client.startCisSession(crossinline block: StartCisSessionRequest.Builder.() -> Unit): StartCisSessionResponse = startCisSession(StartCisSessionRequest.Builder().apply(block).build())

/**
 * Stops a CIS session. This API is used by the Amazon Inspector SSM plugin to communicate with the Amazon Inspector service. The Amazon Inspector SSM plugin calls this API to start a CIS scan session for the scan ID supplied by the service.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.StopCisSession.sample
 */
public suspend inline fun Inspector2Client.stopCisSession(crossinline block: StopCisSessionRequest.Builder.() -> Unit): StopCisSessionResponse = stopCisSession(StopCisSessionRequest.Builder().apply(block).build())

/**
 * Adds tags to a resource.
 */
public suspend inline fun Inspector2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from a resource.
 */
public suspend inline fun Inspector2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a CIS scan configuration.
 *
 * @sample aws.sdk.kotlin.services.inspector2.samples.UpdateCisScanConfiguration.sample
 */
public suspend inline fun Inspector2Client.updateCisScanConfiguration(crossinline block: UpdateCisScanConfigurationRequest.Builder.() -> Unit): UpdateCisScanConfigurationResponse = updateCisScanConfiguration(UpdateCisScanConfigurationRequest.Builder().apply(block).build())

/**
 * Updates setting configurations for your Amazon Inspector account. When you use this API as an Amazon Inspector delegated administrator this updates the setting for all accounts you manage. Member accounts in an organization cannot update this setting.
 */
public suspend inline fun Inspector2Client.updateConfiguration(crossinline block: UpdateConfigurationRequest.Builder.() -> Unit): UpdateConfigurationResponse = updateConfiguration(UpdateConfigurationRequest.Builder().apply(block).build())

/**
 * Activates, deactivates Amazon Inspector deep inspection, or updates custom paths for your account.
 */
public suspend inline fun Inspector2Client.updateEc2DeepInspectionConfiguration(crossinline block: UpdateEc2DeepInspectionConfigurationRequest.Builder.() -> Unit): UpdateEc2DeepInspectionConfigurationResponse = updateEc2DeepInspectionConfiguration(UpdateEc2DeepInspectionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an encryption key. A `ResourceNotFoundException` means that an Amazon Web Services owned key is being used for encryption.
 */
public suspend inline fun Inspector2Client.updateEncryptionKey(crossinline block: UpdateEncryptionKeyRequest.Builder.() -> Unit): UpdateEncryptionKeyResponse = updateEncryptionKey(UpdateEncryptionKeyRequest.Builder().apply(block).build())

/**
 * Specifies the action that is to be applied to the findings that match the filter.
 */
public suspend inline fun Inspector2Client.updateFilter(crossinline block: UpdateFilterRequest.Builder.() -> Unit): UpdateFilterResponse = updateFilter(UpdateFilterRequest.Builder().apply(block).build())

/**
 * Updates the Amazon Inspector deep inspection custom paths for your organization. You must be an Amazon Inspector delegated administrator to use this API.
 */
public suspend inline fun Inspector2Client.updateOrgEc2DeepInspectionConfiguration(crossinline block: UpdateOrgEc2DeepInspectionConfigurationRequest.Builder.() -> Unit): UpdateOrgEc2DeepInspectionConfigurationResponse = updateOrgEc2DeepInspectionConfiguration(UpdateOrgEc2DeepInspectionConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the configurations for your Amazon Inspector organization.
 */
public suspend inline fun Inspector2Client.updateOrganizationConfiguration(crossinline block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit): UpdateOrganizationConfigurationResponse = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())
