// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Details the status of Amazon Inspector for each resource type Amazon Inspector scans.
 */
public class ResourceStatus private constructor(builder: Builder) {
    /**
     * The status of Amazon Inspector scanning for Amazon EC2 resources.
     */
    public val ec2: aws.sdk.kotlin.services.inspector2.model.Status = requireNotNull(builder.ec2) { "A non-null value must be provided for ec2" }
    /**
     * The status of Amazon Inspector scanning for Amazon ECR resources.
     */
    public val ecr: aws.sdk.kotlin.services.inspector2.model.Status = requireNotNull(builder.ecr) { "A non-null value must be provided for ecr" }
    /**
     * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
     */
    public val lambda: aws.sdk.kotlin.services.inspector2.model.Status? = builder.lambda
    /**
     * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
     */
    public val lambdaCode: aws.sdk.kotlin.services.inspector2.model.Status? = builder.lambdaCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.ResourceStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceStatus(")
        append("ec2=$ec2,")
        append("ecr=$ecr,")
        append("lambda=$lambda,")
        append("lambdaCode=$lambdaCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = ec2.hashCode()
        result = 31 * result + (ecr.hashCode())
        result = 31 * result + (lambda?.hashCode() ?: 0)
        result = 31 * result + (lambdaCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceStatus

        if (ec2 != other.ec2) return false
        if (ecr != other.ecr) return false
        if (lambda != other.lambda) return false
        if (lambdaCode != other.lambdaCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.ResourceStatus = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of Amazon Inspector scanning for Amazon EC2 resources.
         */
        public var ec2: aws.sdk.kotlin.services.inspector2.model.Status? = null
        /**
         * The status of Amazon Inspector scanning for Amazon ECR resources.
         */
        public var ecr: aws.sdk.kotlin.services.inspector2.model.Status? = null
        /**
         * The status of Amazon Inspector scanning for Amazon Web Services Lambda function.
         */
        public var lambda: aws.sdk.kotlin.services.inspector2.model.Status? = null
        /**
         * The status of Amazon Inspector scanning for custom application code for Amazon Web Services Lambda functions.
         */
        public var lambdaCode: aws.sdk.kotlin.services.inspector2.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.ResourceStatus) : this() {
            this.ec2 = x.ec2
            this.ecr = x.ecr
            this.lambda = x.lambda
            this.lambdaCode = x.lambdaCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.ResourceStatus = ResourceStatus(this)

        internal fun correctErrors(): Builder {
            if (ec2 == null) ec2 = Status.SdkUnknown("no value provided")
            if (ecr == null) ecr = Status.SdkUnknown("no value provided")
            return this
        }
    }
}
