// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A response that contains the results of an Amazon Web Services Lambda function layer finding aggregation.
 */
public class LambdaLayerAggregationResponse private constructor(builder: Builder) {
    /**
     * The account ID of the Amazon Web Services Lambda function layer.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The names of the Amazon Web Services Lambda functions associated with the layers.
     */
    public val functionName: kotlin.String = requireNotNull(builder.functionName) { "A non-null value must be provided for functionName" }
    /**
     * The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
     */
    public val layerArn: kotlin.String = requireNotNull(builder.layerArn) { "A non-null value must be provided for layerArn" }
    /**
     * The Resource ID of the Amazon Web Services Lambda function layer.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * An object that contains the counts of aggregated finding per severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.LambdaLayerAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaLayerAggregationResponse(")
        append("accountId=$accountId,")
        append("functionName=$functionName,")
        append("layerArn=$layerArn,")
        append("resourceId=$resourceId,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (functionName.hashCode())
        result = 31 * result + (layerArn.hashCode())
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaLayerAggregationResponse

        if (accountId != other.accountId) return false
        if (functionName != other.functionName) return false
        if (layerArn != other.layerArn) return false
        if (resourceId != other.resourceId) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.LambdaLayerAggregationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The account ID of the Amazon Web Services Lambda function layer.
         */
        public var accountId: kotlin.String? = null
        /**
         * The names of the Amazon Web Services Lambda functions associated with the layers.
         */
        public var functionName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Amazon Web Services Lambda function layer.
         */
        public var layerArn: kotlin.String? = null
        /**
         * The Resource ID of the Amazon Web Services Lambda function layer.
         */
        public var resourceId: kotlin.String? = null
        /**
         * An object that contains the counts of aggregated finding per severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.LambdaLayerAggregationResponse) : this() {
            this.accountId = x.accountId
            this.functionName = x.functionName
            this.layerArn = x.layerArn
            this.resourceId = x.resourceId
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.LambdaLayerAggregationResponse = LambdaLayerAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            if (functionName == null) functionName = ""
            if (layerArn == null) layerArn = ""
            if (resourceId == null) resourceId = ""
            return this
        }
    }
}
