// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A response that contains the results of an Amazon Web Services Lambda function finding aggregation.
 */
public class LambdaFunctionAggregationResponse private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Web Services Lambda function names included in the aggregation results.
     */
    public val functionName: kotlin.String? = builder.functionName
    /**
     * The tags included in the aggregation results.
     */
    public val lambdaTags: Map<String, String>? = builder.lambdaTags
    /**
     * The date that the Amazon Web Services Lambda function included in the aggregation results was last changed.
     */
    public val lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedAt
    /**
     * The resource IDs included in the aggregation results.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The runtimes included in the aggregation results.
     */
    public val runtime: kotlin.String? = builder.runtime
    /**
     * An object that contains the counts of aggregated finding per severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAggregationResponse(")
        append("accountId=$accountId,")
        append("functionName=$functionName,")
        append("lambdaTags=$lambdaTags,")
        append("lastModifiedAt=$lastModifiedAt,")
        append("resourceId=$resourceId,")
        append("runtime=$runtime,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (functionName?.hashCode() ?: 0)
        result = 31 * result + (lambdaTags?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (runtime?.hashCode() ?: 0)
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionAggregationResponse

        if (accountId != other.accountId) return false
        if (functionName != other.functionName) return false
        if (lambdaTags != other.lambdaTags) return false
        if (lastModifiedAt != other.lastModifiedAt) return false
        if (resourceId != other.resourceId) return false
        if (runtime != other.runtime) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that owns the Amazon Web Services Lambda function.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Web Services Lambda function names included in the aggregation results.
         */
        public var functionName: kotlin.String? = null
        /**
         * The tags included in the aggregation results.
         */
        public var lambdaTags: Map<String, String>? = null
        /**
         * The date that the Amazon Web Services Lambda function included in the aggregation results was last changed.
         */
        public var lastModifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The resource IDs included in the aggregation results.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The runtimes included in the aggregation results.
         */
        public var runtime: kotlin.String? = null
        /**
         * An object that contains the counts of aggregated finding per severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregationResponse) : this() {
            this.accountId = x.accountId
            this.functionName = x.functionName
            this.lambdaTags = x.lambdaTags
            this.lastModifiedAt = x.lastModifiedAt
            this.resourceId = x.resourceId
            this.runtime = x.runtime
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregationResponse = LambdaFunctionAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resourceId == null) resourceId = ""
            return this
        }
    }
}
