// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information on the code vulnerability identified in your Lambda function.
 */
public class CodeVulnerabilityDetails private constructor(builder: Builder) {
    /**
     * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
     */
    public val cwes: List<String> = requireNotNull(builder.cwes) { "A non-null value must be provided for cwes" }
    /**
     * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see [Amazon CodeGuru Detector Library](https://docs.aws.amazon.com/codeguru/detector-library).
     */
    public val detectorId: kotlin.String = requireNotNull(builder.detectorId) { "A non-null value must be provided for detectorId" }
    /**
     * The name of the detector used to identify the code vulnerability. For more information on detectors see [CodeGuru Detector Library](https://docs.aws.amazon.com/codeguru/detector-library).
     */
    public val detectorName: kotlin.String = requireNotNull(builder.detectorName) { "A non-null value must be provided for detectorName" }
    /**
     * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes or tactics. For a list of available tags by programming language, see [Java tags](https://docs.aws.amazon.com/codeguru/detector-library/java/tags/), or [Python tags](https://docs.aws.amazon.com/codeguru/detector-library/python/tags/).
     */
    public val detectorTags: List<String>? = builder.detectorTags
    /**
     * Contains information on where the code vulnerability is located in your code.
     */
    public val filePath: aws.sdk.kotlin.services.inspector2.model.CodeFilePath? = builder.filePath
    /**
     * A URL containing supporting documentation about the code vulnerability detected.
     */
    public val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * The identifier for a rule that was used to detect the code vulnerability.
     */
    public val ruleId: kotlin.String? = builder.ruleId
    /**
     * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
     */
    public val sourceLambdaLayerArn: kotlin.String? = builder.sourceLambdaLayerArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CodeVulnerabilityDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeVulnerabilityDetails(")
        append("cwes=$cwes,")
        append("detectorId=$detectorId,")
        append("detectorName=$detectorName,")
        append("detectorTags=$detectorTags,")
        append("filePath=$filePath,")
        append("referenceUrls=$referenceUrls,")
        append("ruleId=$ruleId,")
        append("sourceLambdaLayerArn=$sourceLambdaLayerArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cwes.hashCode()
        result = 31 * result + (detectorId.hashCode())
        result = 31 * result + (detectorName.hashCode())
        result = 31 * result + (detectorTags?.hashCode() ?: 0)
        result = 31 * result + (filePath?.hashCode() ?: 0)
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (ruleId?.hashCode() ?: 0)
        result = 31 * result + (sourceLambdaLayerArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeVulnerabilityDetails

        if (cwes != other.cwes) return false
        if (detectorId != other.detectorId) return false
        if (detectorName != other.detectorName) return false
        if (detectorTags != other.detectorTags) return false
        if (filePath != other.filePath) return false
        if (referenceUrls != other.referenceUrls) return false
        if (ruleId != other.ruleId) return false
        if (sourceLambdaLayerArn != other.sourceLambdaLayerArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CodeVulnerabilityDetails = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Common Weakness Enumeration (CWE) item associated with the detected vulnerability.
         */
        public var cwes: List<String>? = null
        /**
         * The ID for the Amazon CodeGuru detector associated with the finding. For more information on detectors see [Amazon CodeGuru Detector Library](https://docs.aws.amazon.com/codeguru/detector-library).
         */
        public var detectorId: kotlin.String? = null
        /**
         * The name of the detector used to identify the code vulnerability. For more information on detectors see [CodeGuru Detector Library](https://docs.aws.amazon.com/codeguru/detector-library).
         */
        public var detectorName: kotlin.String? = null
        /**
         * The detector tag associated with the vulnerability. Detector tags group related vulnerabilities by common themes or tactics. For a list of available tags by programming language, see [Java tags](https://docs.aws.amazon.com/codeguru/detector-library/java/tags/), or [Python tags](https://docs.aws.amazon.com/codeguru/detector-library/python/tags/).
         */
        public var detectorTags: List<String>? = null
        /**
         * Contains information on where the code vulnerability is located in your code.
         */
        public var filePath: aws.sdk.kotlin.services.inspector2.model.CodeFilePath? = null
        /**
         * A URL containing supporting documentation about the code vulnerability detected.
         */
        public var referenceUrls: List<String>? = null
        /**
         * The identifier for a rule that was used to detect the code vulnerability.
         */
        public var ruleId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Lambda layer that the code vulnerability was detected in.
         */
        public var sourceLambdaLayerArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CodeVulnerabilityDetails) : this() {
            this.cwes = x.cwes
            this.detectorId = x.detectorId
            this.detectorName = x.detectorName
            this.detectorTags = x.detectorTags
            this.filePath = x.filePath
            this.referenceUrls = x.referenceUrls
            this.ruleId = x.ruleId
            this.sourceLambdaLayerArn = x.sourceLambdaLayerArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CodeVulnerabilityDetails = CodeVulnerabilityDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.CodeFilePath] inside the given [block]
         */
        public fun filePath(block: aws.sdk.kotlin.services.inspector2.model.CodeFilePath.Builder.() -> kotlin.Unit) {
            this.filePath = aws.sdk.kotlin.services.inspector2.model.CodeFilePath.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (cwes == null) cwes = emptyList()
            if (detectorId == null) detectorId = ""
            if (detectorName == null) detectorName = ""
            return this
        }
    }
}
