// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The CIS scan.
 */
public class CisScan private constructor(builder: Builder) {
    /**
     * The CIS scan's failed checks.
     */
    public val failedChecks: kotlin.Int? = builder.failedChecks
    /**
     * The CIS scan's ARN.
     */
    public val scanArn: kotlin.String = requireNotNull(builder.scanArn) { "A non-null value must be provided for scanArn" }
    /**
     * The CIS scan's configuration ARN.
     */
    public val scanConfigurationArn: kotlin.String = requireNotNull(builder.scanConfigurationArn) { "A non-null value must be provided for scanConfigurationArn" }
    /**
     * The CIS scan's date.
     */
    public val scanDate: aws.smithy.kotlin.runtime.time.Instant? = builder.scanDate
    /**
     * The the name of the scan configuration that's associated with this scan.
     */
    public val scanName: kotlin.String? = builder.scanName
    /**
     * The account or organization that schedules the CIS scan.
     */
    public val scheduledBy: kotlin.String? = builder.scheduledBy
    /**
     * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a profile.
     */
    public val securityLevel: aws.sdk.kotlin.services.inspector2.model.CisSecurityLevel? = builder.securityLevel
    /**
     * The CIS scan's status.
     */
    public val status: aws.sdk.kotlin.services.inspector2.model.CisScanStatus? = builder.status
    /**
     * The CIS scan's targets.
     */
    public val targets: aws.sdk.kotlin.services.inspector2.model.CisTargets? = builder.targets
    /**
     * The CIS scan's total checks.
     */
    public val totalChecks: kotlin.Int? = builder.totalChecks

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CisScan = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CisScan(")
        append("failedChecks=$failedChecks,")
        append("scanArn=$scanArn,")
        append("scanConfigurationArn=$scanConfigurationArn,")
        append("scanDate=$scanDate,")
        append("scanName=$scanName,")
        append("scheduledBy=$scheduledBy,")
        append("securityLevel=$securityLevel,")
        append("status=$status,")
        append("targets=$targets,")
        append("totalChecks=$totalChecks")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = failedChecks ?: 0
        result = 31 * result + (scanArn.hashCode())
        result = 31 * result + (scanConfigurationArn.hashCode())
        result = 31 * result + (scanDate?.hashCode() ?: 0)
        result = 31 * result + (scanName?.hashCode() ?: 0)
        result = 31 * result + (scheduledBy?.hashCode() ?: 0)
        result = 31 * result + (securityLevel?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (totalChecks ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CisScan

        if (failedChecks != other.failedChecks) return false
        if (scanArn != other.scanArn) return false
        if (scanConfigurationArn != other.scanConfigurationArn) return false
        if (scanDate != other.scanDate) return false
        if (scanName != other.scanName) return false
        if (scheduledBy != other.scheduledBy) return false
        if (securityLevel != other.securityLevel) return false
        if (status != other.status) return false
        if (targets != other.targets) return false
        if (totalChecks != other.totalChecks) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CisScan = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The CIS scan's failed checks.
         */
        public var failedChecks: kotlin.Int? = null
        /**
         * The CIS scan's ARN.
         */
        public var scanArn: kotlin.String? = null
        /**
         * The CIS scan's configuration ARN.
         */
        public var scanConfigurationArn: kotlin.String? = null
        /**
         * The CIS scan's date.
         */
        public var scanDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The the name of the scan configuration that's associated with this scan.
         */
        public var scanName: kotlin.String? = null
        /**
         * The account or organization that schedules the CIS scan.
         */
        public var scheduledBy: kotlin.String? = null
        /**
         * The security level for the CIS scan. Security level refers to the Benchmark levels that CIS assigns to a profile.
         */
        public var securityLevel: aws.sdk.kotlin.services.inspector2.model.CisSecurityLevel? = null
        /**
         * The CIS scan's status.
         */
        public var status: aws.sdk.kotlin.services.inspector2.model.CisScanStatus? = null
        /**
         * The CIS scan's targets.
         */
        public var targets: aws.sdk.kotlin.services.inspector2.model.CisTargets? = null
        /**
         * The CIS scan's total checks.
         */
        public var totalChecks: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CisScan) : this() {
            this.failedChecks = x.failedChecks
            this.scanArn = x.scanArn
            this.scanConfigurationArn = x.scanConfigurationArn
            this.scanDate = x.scanDate
            this.scanName = x.scanName
            this.scheduledBy = x.scheduledBy
            this.securityLevel = x.securityLevel
            this.status = x.status
            this.targets = x.targets
            this.totalChecks = x.totalChecks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CisScan = CisScan(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.CisTargets] inside the given [block]
         */
        public fun targets(block: aws.sdk.kotlin.services.inspector2.model.CisTargets.Builder.() -> kotlin.Unit) {
            this.targets = aws.sdk.kotlin.services.inspector2.model.CisTargets.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (scanArn == null) scanArn = ""
            if (scanConfigurationArn == null) scanConfigurationArn = ""
            return this
        }
    }
}
