// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.serde

import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.sdk.kotlin.services.inspector2.model.UpdateOrgEc2DeepInspectionConfigurationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class UpdateOrgEc2DeepInspectionConfigurationOperationDeserializer: HttpDeserialize<UpdateOrgEc2DeepInspectionConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateOrgEc2DeepInspectionConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateOrgEc2DeepInspectionConfigurationError(context, call)
        }
        val builder = UpdateOrgEc2DeepInspectionConfigurationResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateOrgEc2DeepInspectionConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
