// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.serde

import aws.sdk.kotlin.services.inspector2.model.Destination
import aws.sdk.kotlin.services.inspector2.model.ExternalReportStatus
import aws.sdk.kotlin.services.inspector2.model.FilterCriteria
import aws.sdk.kotlin.services.inspector2.model.GetFindingsReportStatusResponse
import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.sdk.kotlin.services.inspector2.model.ReportingErrorCode
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetFindingsReportStatusOperationDeserializer: HttpDeserialize<GetFindingsReportStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetFindingsReportStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetFindingsReportStatusError(context, call)
        }
        val builder = GetFindingsReportStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetFindingsReportStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetFindingsReportStatusError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetFindingsReportStatusOperationBody(builder: GetFindingsReportStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destination"))
    val ERRORCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorCode"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val FILTERCRITERIA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("filterCriteria"))
    val REPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("reportId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATION_DESCRIPTOR)
        field(ERRORCODE_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(FILTERCRITERIA_DESCRIPTOR)
        field(REPORTID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATION_DESCRIPTOR.index -> builder.destination = deserializeDestinationDocument(deserializer)
                ERRORCODE_DESCRIPTOR.index -> builder.errorCode = deserializeString().let { ReportingErrorCode.fromValue(it) }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                FILTERCRITERIA_DESCRIPTOR.index -> builder.filterCriteria = deserializeFilterCriteriaDocument(deserializer)
                REPORTID_DESCRIPTOR.index -> builder.reportId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ExternalReportStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
