// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.serde

import aws.sdk.kotlin.services.inspector2.model.AutoEnable
import aws.sdk.kotlin.services.inspector2.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeOrganizationConfigurationOperationDeserializer: HttpDeserialize<DescribeOrganizationConfigurationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeOrganizationConfigurationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeOrganizationConfigurationError(context, call)
        }
        val builder = DescribeOrganizationConfigurationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeOrganizationConfigurationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeOrganizationConfigurationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeOrganizationConfigurationOperationBody(builder: DescribeOrganizationConfigurationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTOENABLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoEnable"))
    val MAXACCOUNTLIMITREACHED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("maxAccountLimitReached"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTOENABLE_DESCRIPTOR)
        field(MAXACCOUNTLIMITREACHED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTOENABLE_DESCRIPTOR.index -> builder.autoEnable = deserializeAutoEnableDocument(deserializer)
                MAXACCOUNTLIMITREACHED_DESCRIPTOR.index -> builder.maxAccountLimitReached = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
