// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.serde

import aws.sdk.kotlin.services.inspector2.model.BatchGetMemberEc2DeepInspectionStatusResponse
import aws.sdk.kotlin.services.inspector2.model.FailedMemberAccountEc2DeepInspectionStatusState
import aws.sdk.kotlin.services.inspector2.model.Inspector2Exception
import aws.sdk.kotlin.services.inspector2.model.MemberAccountEc2DeepInspectionStatusState
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchGetMemberEc2DeepInspectionStatusOperationDeserializer: HttpDeserialize<BatchGetMemberEc2DeepInspectionStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): BatchGetMemberEc2DeepInspectionStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchGetMemberEc2DeepInspectionStatusError(context, call)
        }
        val builder = BatchGetMemberEc2DeepInspectionStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetMemberEc2DeepInspectionStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwBatchGetMemberEc2DeepInspectionStatusError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw Inspector2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> Inspector2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetMemberEc2DeepInspectionStatusOperationBody(builder: BatchGetMemberEc2DeepInspectionStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("accountIds"))
    val FAILEDACCOUNTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedAccountIds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTIDS_DESCRIPTOR)
        field(FAILEDACCOUNTIDS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTIDS_DESCRIPTOR.index -> builder.accountIds =
                    deserializer.deserializeList(ACCOUNTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<MemberAccountEc2DeepInspectionStatusState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMemberAccountEc2DeepInspectionStatusStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                FAILEDACCOUNTIDS_DESCRIPTOR.index -> builder.failedAccountIds =
                    deserializer.deserializeList(FAILEDACCOUNTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedMemberAccountEc2DeepInspectionStatusState>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedMemberAccountEc2DeepInspectionStatusStateDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
