// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.paginators

import aws.sdk.kotlin.services.inspector2.Inspector2Client
import aws.sdk.kotlin.services.inspector2.model.AggregationResponse
import aws.sdk.kotlin.services.inspector2.model.Counts
import aws.sdk.kotlin.services.inspector2.model.CoveredResource
import aws.sdk.kotlin.services.inspector2.model.DelegatedAdminAccount
import aws.sdk.kotlin.services.inspector2.model.Filter
import aws.sdk.kotlin.services.inspector2.model.Finding
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsRequest
import aws.sdk.kotlin.services.inspector2.model.ListAccountPermissionsResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageResponse
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsRequest
import aws.sdk.kotlin.services.inspector2.model.ListCoverageStatisticsResponse
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsRequest
import aws.sdk.kotlin.services.inspector2.model.ListDelegatedAdminAccountsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFiltersRequest
import aws.sdk.kotlin.services.inspector2.model.ListFiltersResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingAggregationsResponse
import aws.sdk.kotlin.services.inspector2.model.ListFindingsRequest
import aws.sdk.kotlin.services.inspector2.model.ListFindingsResponse
import aws.sdk.kotlin.services.inspector2.model.ListMembersRequest
import aws.sdk.kotlin.services.inspector2.model.ListMembersResponse
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsRequest
import aws.sdk.kotlin.services.inspector2.model.ListUsageTotalsResponse
import aws.sdk.kotlin.services.inspector2.model.Member
import aws.sdk.kotlin.services.inspector2.model.Permission
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesRequest
import aws.sdk.kotlin.services.inspector2.model.SearchVulnerabilitiesResponse
import aws.sdk.kotlin.services.inspector2.model.UsageTotal
import aws.sdk.kotlin.services.inspector2.model.Vulnerability
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccountPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountPermissionsResponse]
 */
public fun Inspector2Client.listAccountPermissionsPaginated(initialRequest: ListAccountPermissionsRequest = ListAccountPermissionsRequest { }): Flow<ListAccountPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountPermissionsPaginated.listAccountPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountPermissionsResponse]
 */
public fun Inspector2Client.listAccountPermissionsPaginated(block: ListAccountPermissionsRequest.Builder.() -> Unit): Flow<ListAccountPermissionsResponse> =
    listAccountPermissionsPaginated(ListAccountPermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAccountPermissionsPaginated]
 * to access the nested member [Permission]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Permission]
 */
@JvmName("listAccountPermissionsResponsePermission")
public fun Flow<ListAccountPermissionsResponse>.permissions(): Flow<Permission> =
    transform() { response ->
        response.permissions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoverageRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageResponse]
 */
public fun Inspector2Client.listCoveragePaginated(initialRequest: ListCoverageRequest = ListCoverageRequest { }): Flow<ListCoverageResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoveragePaginated.listCoverage(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoverageResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageResponse]
 */
public fun Inspector2Client.listCoveragePaginated(block: ListCoverageRequest.Builder.() -> Unit): Flow<ListCoverageResponse> =
    listCoveragePaginated(ListCoverageRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoveragePaginated]
 * to access the nested member [CoveredResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CoveredResource]
 */
@JvmName("listCoverageResponseCoveredResource")
public fun Flow<ListCoverageResponse>.coveredResources(): Flow<CoveredResource> =
    transform() { response ->
        response.coveredResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCoverageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCoverageStatisticsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageStatisticsResponse]
 */
public fun Inspector2Client.listCoverageStatisticsPaginated(initialRequest: ListCoverageStatisticsRequest = ListCoverageStatisticsRequest { }): Flow<ListCoverageStatisticsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCoverageStatisticsPaginated.listCoverageStatistics(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCoverageStatisticsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCoverageStatisticsResponse]
 */
public fun Inspector2Client.listCoverageStatisticsPaginated(block: ListCoverageStatisticsRequest.Builder.() -> Unit): Flow<ListCoverageStatisticsResponse> =
    listCoverageStatisticsPaginated(ListCoverageStatisticsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCoverageStatisticsPaginated]
 * to access the nested member [Counts]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Counts]
 */
@JvmName("listCoverageStatisticsResponseCounts")
public fun Flow<ListCoverageStatisticsResponse>.countsByGroup(): Flow<Counts> =
    transform() { response ->
        response.countsByGroup?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDelegatedAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDelegatedAdminAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdminAccountsResponse]
 */
public fun Inspector2Client.listDelegatedAdminAccountsPaginated(initialRequest: ListDelegatedAdminAccountsRequest = ListDelegatedAdminAccountsRequest { }): Flow<ListDelegatedAdminAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDelegatedAdminAccountsPaginated.listDelegatedAdminAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDelegatedAdminAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDelegatedAdminAccountsResponse]
 */
public fun Inspector2Client.listDelegatedAdminAccountsPaginated(block: ListDelegatedAdminAccountsRequest.Builder.() -> Unit): Flow<ListDelegatedAdminAccountsResponse> =
    listDelegatedAdminAccountsPaginated(ListDelegatedAdminAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDelegatedAdminAccountsPaginated]
 * to access the nested member [DelegatedAdminAccount]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DelegatedAdminAccount]
 */
@JvmName("listDelegatedAdminAccountsResponseDelegatedAdminAccount")
public fun Flow<ListDelegatedAdminAccountsResponse>.delegatedAdminAccounts(): Flow<DelegatedAdminAccount> =
    transform() { response ->
        response.delegatedAdminAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFiltersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun Inspector2Client.listFiltersPaginated(initialRequest: ListFiltersRequest = ListFiltersRequest { }): Flow<ListFiltersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFiltersPaginated.listFilters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFiltersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFiltersResponse]
 */
public fun Inspector2Client.listFiltersPaginated(block: ListFiltersRequest.Builder.() -> Unit): Flow<ListFiltersResponse> =
    listFiltersPaginated(ListFiltersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFiltersPaginated]
 * to access the nested member [Filter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Filter]
 */
@JvmName("listFiltersResponseFilter")
public fun Flow<ListFiltersResponse>.filters(): Flow<Filter> =
    transform() { response ->
        response.filters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingAggregationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregationsResponse]
 */
public fun Inspector2Client.listFindingAggregationsPaginated(initialRequest: ListFindingAggregationsRequest): Flow<ListFindingAggregationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingAggregationsPaginated.listFindingAggregations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingAggregationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingAggregationsResponse]
 */
public fun Inspector2Client.listFindingAggregationsPaginated(block: ListFindingAggregationsRequest.Builder.() -> Unit): Flow<ListFindingAggregationsResponse> =
    listFindingAggregationsPaginated(ListFindingAggregationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingAggregationsPaginated]
 * to access the nested member [AggregationResponse]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AggregationResponse]
 */
@JvmName("listFindingAggregationsResponseAggregationResponse")
public fun Flow<ListFindingAggregationsResponse>.responses(): Flow<AggregationResponse> =
    transform() { response ->
        response.responses?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFindingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Inspector2Client.listFindingsPaginated(initialRequest: ListFindingsRequest = ListFindingsRequest { }): Flow<ListFindingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFindingsPaginated.listFindings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFindingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFindingsResponse]
 */
public fun Inspector2Client.listFindingsPaginated(block: ListFindingsRequest.Builder.() -> Unit): Flow<ListFindingsResponse> =
    listFindingsPaginated(ListFindingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listFindingsPaginated]
 * to access the nested member [Finding]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Finding]
 */
@JvmName("listFindingsResponseFinding")
public fun Flow<ListFindingsResponse>.findings(): Flow<Finding> =
    transform() { response ->
        response.findings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMembersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Inspector2Client.listMembersPaginated(initialRequest: ListMembersRequest = ListMembersRequest { }): Flow<ListMembersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMembersPaginated.listMembers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMembersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMembersResponse]
 */
public fun Inspector2Client.listMembersPaginated(block: ListMembersRequest.Builder.() -> Unit): Flow<ListMembersResponse> =
    listMembersPaginated(ListMembersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMembersPaginated]
 * to access the nested member [Member]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Member]
 */
@JvmName("listMembersResponseMember")
public fun Flow<ListMembersResponse>.members(): Flow<Member> =
    transform() { response ->
        response.members?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListUsageTotalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListUsageTotalsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsageTotalsResponse]
 */
public fun Inspector2Client.listUsageTotalsPaginated(initialRequest: ListUsageTotalsRequest = ListUsageTotalsRequest { }): Flow<ListUsageTotalsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listUsageTotalsPaginated.listUsageTotals(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListUsageTotalsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListUsageTotalsResponse]
 */
public fun Inspector2Client.listUsageTotalsPaginated(block: ListUsageTotalsRequest.Builder.() -> Unit): Flow<ListUsageTotalsResponse> =
    listUsageTotalsPaginated(ListUsageTotalsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listUsageTotalsPaginated]
 * to access the nested member [UsageTotal]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [UsageTotal]
 */
@JvmName("listUsageTotalsResponseUsageTotal")
public fun Flow<ListUsageTotalsResponse>.totals(): Flow<UsageTotal> =
    transform() { response ->
        response.totals?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchVulnerabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchVulnerabilitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVulnerabilitiesResponse]
 */
public fun Inspector2Client.searchVulnerabilitiesPaginated(initialRequest: SearchVulnerabilitiesRequest): Flow<SearchVulnerabilitiesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchVulnerabilitiesPaginated.searchVulnerabilities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchVulnerabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchVulnerabilitiesResponse]
 */
public fun Inspector2Client.searchVulnerabilitiesPaginated(block: SearchVulnerabilitiesRequest.Builder.() -> Unit): Flow<SearchVulnerabilitiesResponse> =
    searchVulnerabilitiesPaginated(SearchVulnerabilitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchVulnerabilitiesPaginated]
 * to access the nested member [Vulnerability]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Vulnerability]
 */
@JvmName("searchVulnerabilitiesResponseVulnerability")
public fun Flow<SearchVulnerabilitiesResponse>.vulnerabilities(): Flow<Vulnerability> =
    transform() { response ->
        response.vulnerabilities?.forEach {
            emit(it)
        }
    }
