// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * The resource filter criteria for a Software bill of materials (SBOM) report.
 */
public class ResourceFilterCriteria private constructor(builder: Builder) {
    /**
     * The account IDs used as resource filter criteria.
     */
    public val accountId: List<ResourceStringFilter>? = builder.accountId
    /**
     * The EC2 instance tags used as resource filter criteria.
     */
    public val ec2InstanceTags: List<ResourceMapFilter>? = builder.ec2InstanceTags
    /**
     * The ECR image tags used as resource filter criteria.
     */
    public val ecrImageTags: List<ResourceStringFilter>? = builder.ecrImageTags
    /**
     * The ECR repository names used as resource filter criteria.
     */
    public val ecrRepositoryName: List<ResourceStringFilter>? = builder.ecrRepositoryName
    /**
     * The AWS Lambda function name used as resource filter criteria.
     */
    public val lambdaFunctionName: List<ResourceStringFilter>? = builder.lambdaFunctionName
    /**
     * The AWS Lambda function tags used as resource filter criteria.
     */
    public val lambdaFunctionTags: List<ResourceMapFilter>? = builder.lambdaFunctionTags
    /**
     * The resource IDs used as resource filter criteria.
     */
    public val resourceId: List<ResourceStringFilter>? = builder.resourceId
    /**
     * The resource types used as resource filter criteria.
     */
    public val resourceType: List<ResourceStringFilter>? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.ResourceFilterCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceFilterCriteria(")
        append("accountId=$accountId,")
        append("ec2InstanceTags=$ec2InstanceTags,")
        append("ecrImageTags=$ecrImageTags,")
        append("ecrRepositoryName=$ecrRepositoryName,")
        append("lambdaFunctionName=$lambdaFunctionName,")
        append("lambdaFunctionTags=$lambdaFunctionTags,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceTags?.hashCode() ?: 0)
        result = 31 * result + (ecrImageTags?.hashCode() ?: 0)
        result = 31 * result + (ecrRepositoryName?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionName?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionTags?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceFilterCriteria

        if (accountId != other.accountId) return false
        if (ec2InstanceTags != other.ec2InstanceTags) return false
        if (ecrImageTags != other.ecrImageTags) return false
        if (ecrRepositoryName != other.ecrRepositoryName) return false
        if (lambdaFunctionName != other.lambdaFunctionName) return false
        if (lambdaFunctionTags != other.lambdaFunctionTags) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.ResourceFilterCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account IDs used as resource filter criteria.
         */
        public var accountId: List<ResourceStringFilter>? = null
        /**
         * The EC2 instance tags used as resource filter criteria.
         */
        public var ec2InstanceTags: List<ResourceMapFilter>? = null
        /**
         * The ECR image tags used as resource filter criteria.
         */
        public var ecrImageTags: List<ResourceStringFilter>? = null
        /**
         * The ECR repository names used as resource filter criteria.
         */
        public var ecrRepositoryName: List<ResourceStringFilter>? = null
        /**
         * The AWS Lambda function name used as resource filter criteria.
         */
        public var lambdaFunctionName: List<ResourceStringFilter>? = null
        /**
         * The AWS Lambda function tags used as resource filter criteria.
         */
        public var lambdaFunctionTags: List<ResourceMapFilter>? = null
        /**
         * The resource IDs used as resource filter criteria.
         */
        public var resourceId: List<ResourceStringFilter>? = null
        /**
         * The resource types used as resource filter criteria.
         */
        public var resourceType: List<ResourceStringFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.ResourceFilterCriteria) : this() {
            this.accountId = x.accountId
            this.ec2InstanceTags = x.ec2InstanceTags
            this.ecrImageTags = x.ecrImageTags
            this.ecrRepositoryName = x.ecrRepositoryName
            this.lambdaFunctionName = x.lambdaFunctionName
            this.lambdaFunctionTags = x.lambdaFunctionTags
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.ResourceFilterCriteria = ResourceFilterCriteria(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
