// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a package vulnerability finding.
 */
public class PackageVulnerabilityDetails private constructor(builder: Builder) {
    /**
     * An object that contains details about the CVSS score of a finding.
     */
    public val cvss: List<CvssScore>? = builder.cvss
    /**
     * One or more URLs that contain details about this vulnerability type.
     */
    public val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * One or more vulnerabilities related to the one identified in this finding.
     */
    public val relatedVulnerabilities: List<String>? = builder.relatedVulnerabilities
    /**
     * The source of the vulnerability information.
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * A URL to the source of the vulnerability information.
     */
    public val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * The date and time that this vulnerability was first added to the vendor's database.
     */
    public val vendorCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.vendorCreatedAt
    /**
     * The severity the vendor has given to this vulnerability type.
     */
    public val vendorSeverity: kotlin.String? = builder.vendorSeverity
    /**
     * The date and time the vendor last updated this vulnerability in their database.
     */
    public val vendorUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.vendorUpdatedAt
    /**
     * The ID given to this vulnerability.
     */
    public val vulnerabilityId: kotlin.String = requireNotNull(builder.vulnerabilityId) { "A non-null value must be provided for vulnerabilityId" }
    /**
     * The packages impacted by this vulnerability.
     */
    public val vulnerablePackages: List<VulnerablePackage>? = builder.vulnerablePackages

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PackageVulnerabilityDetails(")
        append("cvss=$cvss,")
        append("referenceUrls=$referenceUrls,")
        append("relatedVulnerabilities=$relatedVulnerabilities,")
        append("source=$source,")
        append("sourceUrl=$sourceUrl,")
        append("vendorCreatedAt=$vendorCreatedAt,")
        append("vendorSeverity=$vendorSeverity,")
        append("vendorUpdatedAt=$vendorUpdatedAt,")
        append("vulnerabilityId=$vulnerabilityId,")
        append("vulnerablePackages=$vulnerablePackages")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cvss?.hashCode() ?: 0
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (relatedVulnerabilities?.hashCode() ?: 0)
        result = 31 * result + (source.hashCode())
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (vendorCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (vendorSeverity?.hashCode() ?: 0)
        result = 31 * result + (vendorUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (vulnerabilityId.hashCode())
        result = 31 * result + (vulnerablePackages?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PackageVulnerabilityDetails

        if (cvss != other.cvss) return false
        if (referenceUrls != other.referenceUrls) return false
        if (relatedVulnerabilities != other.relatedVulnerabilities) return false
        if (source != other.source) return false
        if (sourceUrl != other.sourceUrl) return false
        if (vendorCreatedAt != other.vendorCreatedAt) return false
        if (vendorSeverity != other.vendorSeverity) return false
        if (vendorUpdatedAt != other.vendorUpdatedAt) return false
        if (vulnerabilityId != other.vulnerabilityId) return false
        if (vulnerablePackages != other.vulnerablePackages) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains details about the CVSS score of a finding.
         */
        public var cvss: List<CvssScore>? = null
        /**
         * One or more URLs that contain details about this vulnerability type.
         */
        public var referenceUrls: List<String>? = null
        /**
         * One or more vulnerabilities related to the one identified in this finding.
         */
        public var relatedVulnerabilities: List<String>? = null
        /**
         * The source of the vulnerability information.
         */
        public var source: kotlin.String? = null
        /**
         * A URL to the source of the vulnerability information.
         */
        public var sourceUrl: kotlin.String? = null
        /**
         * The date and time that this vulnerability was first added to the vendor's database.
         */
        public var vendorCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The severity the vendor has given to this vulnerability type.
         */
        public var vendorSeverity: kotlin.String? = null
        /**
         * The date and time the vendor last updated this vulnerability in their database.
         */
        public var vendorUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID given to this vulnerability.
         */
        public var vulnerabilityId: kotlin.String? = null
        /**
         * The packages impacted by this vulnerability.
         */
        public var vulnerablePackages: List<VulnerablePackage>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails) : this() {
            this.cvss = x.cvss
            this.referenceUrls = x.referenceUrls
            this.relatedVulnerabilities = x.relatedVulnerabilities
            this.source = x.source
            this.sourceUrl = x.sourceUrl
            this.vendorCreatedAt = x.vendorCreatedAt
            this.vendorSeverity = x.vendorSeverity
            this.vendorUpdatedAt = x.vendorUpdatedAt
            this.vulnerabilityId = x.vulnerabilityId
            this.vulnerablePackages = x.vulnerablePackages
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.PackageVulnerabilityDetails = PackageVulnerabilityDetails(this)

        internal fun correctErrors(): Builder {
            if (source == null) source = ""
            if (vulnerabilityId == null) vulnerabilityId = ""
            return this
        }
    }
}
