// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * The details that define a findings aggregation based on AWS Lambda functions.
 */
public class LambdaFunctionAggregation private constructor(builder: Builder) {
    /**
     * The AWS Lambda function names to include in the aggregation results.
     */
    public val functionNames: List<StringFilter>? = builder.functionNames
    /**
     * The tags to include in the aggregation results.
     */
    public val functionTags: List<MapFilter>? = builder.functionTags
    /**
     * The resource IDs to include in the aggregation results.
     */
    public val resourceIds: List<StringFilter>? = builder.resourceIds
    /**
     * Returns findings aggregated by AWS Lambda function runtime environments.
     */
    public val runtimes: List<StringFilter>? = builder.runtimes
    /**
     * The finding severity to use for sorting the results.
     */
    public val sortBy: aws.sdk.kotlin.services.inspector2.model.LambdaFunctionSortBy? = builder.sortBy
    /**
     * The order to use for sorting the results.
     */
    public val sortOrder: aws.sdk.kotlin.services.inspector2.model.SortOrder? = builder.sortOrder

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LambdaFunctionAggregation(")
        append("functionNames=$functionNames,")
        append("functionTags=$functionTags,")
        append("resourceIds=$resourceIds,")
        append("runtimes=$runtimes,")
        append("sortBy=$sortBy,")
        append("sortOrder=$sortOrder")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionNames?.hashCode() ?: 0
        result = 31 * result + (functionTags?.hashCode() ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        result = 31 * result + (runtimes?.hashCode() ?: 0)
        result = 31 * result + (sortBy?.hashCode() ?: 0)
        result = 31 * result + (sortOrder?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LambdaFunctionAggregation

        if (functionNames != other.functionNames) return false
        if (functionTags != other.functionTags) return false
        if (resourceIds != other.resourceIds) return false
        if (runtimes != other.runtimes) return false
        if (sortBy != other.sortBy) return false
        if (sortOrder != other.sortOrder) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The AWS Lambda function names to include in the aggregation results.
         */
        public var functionNames: List<StringFilter>? = null
        /**
         * The tags to include in the aggregation results.
         */
        public var functionTags: List<MapFilter>? = null
        /**
         * The resource IDs to include in the aggregation results.
         */
        public var resourceIds: List<StringFilter>? = null
        /**
         * Returns findings aggregated by AWS Lambda function runtime environments.
         */
        public var runtimes: List<StringFilter>? = null
        /**
         * The finding severity to use for sorting the results.
         */
        public var sortBy: aws.sdk.kotlin.services.inspector2.model.LambdaFunctionSortBy? = null
        /**
         * The order to use for sorting the results.
         */
        public var sortOrder: aws.sdk.kotlin.services.inspector2.model.SortOrder? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregation) : this() {
            this.functionNames = x.functionNames
            this.functionTags = x.functionTags
            this.resourceIds = x.resourceIds
            this.runtimes = x.runtimes
            this.sortBy = x.sortBy
            this.sortOrder = x.sortOrder
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.LambdaFunctionAggregation = LambdaFunctionAggregation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
