// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * A response that contains the results of a finding aggregation by image layer.
 */
public class ImageLayerAggregationResponse private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that owns the container image hosting the layer image.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * The layer hash.
     */
    public val layerHash: kotlin.String = requireNotNull(builder.layerHash) { "A non-null value must be provided for layerHash" }
    /**
     * The repository the layer resides in.
     */
    public val repository: kotlin.String = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }
    /**
     * The resource ID of the container image layer.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * An object that represents the count of matched findings per severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.ImageLayerAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageLayerAggregationResponse(")
        append("accountId=$accountId,")
        append("layerHash=$layerHash,")
        append("repository=$repository,")
        append("resourceId=$resourceId,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (layerHash.hashCode())
        result = 31 * result + (repository.hashCode())
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageLayerAggregationResponse

        if (accountId != other.accountId) return false
        if (layerHash != other.layerHash) return false
        if (repository != other.repository) return false
        if (resourceId != other.resourceId) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.ImageLayerAggregationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account that owns the container image hosting the layer image.
         */
        public var accountId: kotlin.String? = null
        /**
         * The layer hash.
         */
        public var layerHash: kotlin.String? = null
        /**
         * The repository the layer resides in.
         */
        public var repository: kotlin.String? = null
        /**
         * The resource ID of the container image layer.
         */
        public var resourceId: kotlin.String? = null
        /**
         * An object that represents the count of matched findings per severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.ImageLayerAggregationResponse) : this() {
            this.accountId = x.accountId
            this.layerHash = x.layerHash
            this.repository = x.repository
            this.resourceId = x.resourceId
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.ImageLayerAggregationResponse = ImageLayerAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            if (layerHash == null) layerHash = ""
            if (repository == null) repository = ""
            if (resourceId == null) resourceId = ""
            return this
        }
    }
}
