// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * Details of the vulnerability identified in a finding.
 */
public class FindingDetail private constructor(builder: Builder) {
    /**
     * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
     */
    public val cisaData: aws.sdk.kotlin.services.inspector2.model.CisaData? = builder.cisaData
    /**
     * The Common Weakness Enumerations (CWEs) associated with the vulnerability.
     */
    public val cwes: List<String>? = builder.cwes
    /**
     * The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
     */
    public val epssScore: kotlin.Double? = builder.epssScore
    /**
     * Information on the evidence of the vulnerability.
     */
    public val evidences: List<Evidence>? = builder.evidences
    /**
     * Contains information on when this exploit was observed.
     */
    public val exploitObserved: aws.sdk.kotlin.services.inspector2.model.ExploitObserved? = builder.exploitObserved
    /**
     * The finding ARN that the vulnerability details are associated with.
     */
    public val findingArn: kotlin.String? = builder.findingArn
    /**
     * The reference URLs for the vulnerability data.
     */
    public val referenceUrls: List<String>? = builder.referenceUrls
    /**
     * The risk score of the vulnerability.
     */
    public val riskScore: kotlin.Int? = builder.riskScore
    /**
     * The known malware tools or kits that can exploit the vulnerability.
     */
    public val tools: List<String>? = builder.tools
    /**
     * The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
     */
    public val ttps: List<String>? = builder.ttps

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.FindingDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FindingDetail(")
        append("cisaData=$cisaData,")
        append("cwes=$cwes,")
        append("epssScore=$epssScore,")
        append("evidences=$evidences,")
        append("exploitObserved=$exploitObserved,")
        append("findingArn=$findingArn,")
        append("referenceUrls=$referenceUrls,")
        append("riskScore=$riskScore,")
        append("tools=$tools,")
        append("ttps=$ttps")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cisaData?.hashCode() ?: 0
        result = 31 * result + (cwes?.hashCode() ?: 0)
        result = 31 * result + (epssScore?.hashCode() ?: 0)
        result = 31 * result + (evidences?.hashCode() ?: 0)
        result = 31 * result + (exploitObserved?.hashCode() ?: 0)
        result = 31 * result + (findingArn?.hashCode() ?: 0)
        result = 31 * result + (referenceUrls?.hashCode() ?: 0)
        result = 31 * result + (riskScore ?: 0)
        result = 31 * result + (tools?.hashCode() ?: 0)
        result = 31 * result + (ttps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FindingDetail

        if (cisaData != other.cisaData) return false
        if (cwes != other.cwes) return false
        if (epssScore != other.epssScore) return false
        if (evidences != other.evidences) return false
        if (exploitObserved != other.exploitObserved) return false
        if (findingArn != other.findingArn) return false
        if (referenceUrls != other.referenceUrls) return false
        if (riskScore != other.riskScore) return false
        if (tools != other.tools) return false
        if (ttps != other.ttps) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.FindingDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Cybersecurity and Infrastructure Security Agency (CISA) details for a specific vulnerability.
         */
        public var cisaData: aws.sdk.kotlin.services.inspector2.model.CisaData? = null
        /**
         * The Common Weakness Enumerations (CWEs) associated with the vulnerability.
         */
        public var cwes: List<String>? = null
        /**
         * The Exploit Prediction Scoring System (EPSS) score of the vulnerability.
         */
        public var epssScore: kotlin.Double? = null
        /**
         * Information on the evidence of the vulnerability.
         */
        public var evidences: List<Evidence>? = null
        /**
         * Contains information on when this exploit was observed.
         */
        public var exploitObserved: aws.sdk.kotlin.services.inspector2.model.ExploitObserved? = null
        /**
         * The finding ARN that the vulnerability details are associated with.
         */
        public var findingArn: kotlin.String? = null
        /**
         * The reference URLs for the vulnerability data.
         */
        public var referenceUrls: List<String>? = null
        /**
         * The risk score of the vulnerability.
         */
        public var riskScore: kotlin.Int? = null
        /**
         * The known malware tools or kits that can exploit the vulnerability.
         */
        public var tools: List<String>? = null
        /**
         * The MITRE adversary tactics, techniques, or procedures (TTPs) associated with the vulnerability.
         */
        public var ttps: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.FindingDetail) : this() {
            this.cisaData = x.cisaData
            this.cwes = x.cwes
            this.epssScore = x.epssScore
            this.evidences = x.evidences
            this.exploitObserved = x.exploitObserved
            this.findingArn = x.findingArn
            this.referenceUrls = x.referenceUrls
            this.riskScore = x.riskScore
            this.tools = x.tools
            this.ttps = x.ttps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.FindingDetail = FindingDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.CisaData] inside the given [block]
         */
        public fun cisaData(block: aws.sdk.kotlin.services.inspector2.model.CisaData.Builder.() -> kotlin.Unit) {
            this.cisaData = aws.sdk.kotlin.services.inspector2.model.CisaData.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ExploitObserved] inside the given [block]
         */
        public fun exploitObserved(block: aws.sdk.kotlin.services.inspector2.model.ExploitObserved.Builder.() -> kotlin.Unit) {
            this.exploitObserved = aws.sdk.kotlin.services.inspector2.model.ExploitObserved.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
