// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * A response that contains the results of a finding aggregation by Amazon EC2 instance.
 */
public class Ec2InstanceAggregationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account for the Amazon EC2 instance.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Machine Image (AMI) of the Amazon EC2 instance.
     */
    public val ami: kotlin.String? = builder.ami
    /**
     * The Amazon EC2 instance ID.
     */
    public val instanceId: kotlin.String = requireNotNull(builder.instanceId) { "A non-null value must be provided for instanceId" }
    /**
     * The tags attached to the instance.
     */
    public val instanceTags: Map<String, String>? = builder.instanceTags
    /**
     * The number of network findings for the Amazon EC2 instance.
     */
    public val networkFindings: kotlin.Long? = builder.networkFindings
    /**
     * The operating system of the Amazon EC2 instance.
     */
    public val operatingSystem: kotlin.String? = builder.operatingSystem
    /**
     * An object that contains the count of matched findings per severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ec2InstanceAggregationResponse(")
        append("accountId=$accountId,")
        append("ami=$ami,")
        append("instanceId=$instanceId,")
        append("instanceTags=$instanceTags,")
        append("networkFindings=$networkFindings,")
        append("operatingSystem=$operatingSystem,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (ami?.hashCode() ?: 0)
        result = 31 * result + (instanceId.hashCode())
        result = 31 * result + (instanceTags?.hashCode() ?: 0)
        result = 31 * result + (networkFindings?.hashCode() ?: 0)
        result = 31 * result + (operatingSystem?.hashCode() ?: 0)
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ec2InstanceAggregationResponse

        if (accountId != other.accountId) return false
        if (ami != other.ami) return false
        if (instanceId != other.instanceId) return false
        if (instanceTags != other.instanceTags) return false
        if (networkFindings != other.networkFindings) return false
        if (operatingSystem != other.operatingSystem) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account for the Amazon EC2 instance.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Machine Image (AMI) of the Amazon EC2 instance.
         */
        public var ami: kotlin.String? = null
        /**
         * The Amazon EC2 instance ID.
         */
        public var instanceId: kotlin.String? = null
        /**
         * The tags attached to the instance.
         */
        public var instanceTags: Map<String, String>? = null
        /**
         * The number of network findings for the Amazon EC2 instance.
         */
        public var networkFindings: kotlin.Long? = null
        /**
         * The operating system of the Amazon EC2 instance.
         */
        public var operatingSystem: kotlin.String? = null
        /**
         * An object that contains the count of matched findings per severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregationResponse) : this() {
            this.accountId = x.accountId
            this.ami = x.ami
            this.instanceId = x.instanceId
            this.instanceTags = x.instanceTags
            this.networkFindings = x.networkFindings
            this.operatingSystem = x.operatingSystem
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.Ec2InstanceAggregationResponse = Ec2InstanceAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (instanceId == null) instanceId = ""
            return this
        }
    }
}
