// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * Information about the CVSS score.
 */
public class CvssScoreDetails private constructor(builder: Builder) {
    /**
     * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
     */
    public val adjustments: List<CvssScoreAdjustment>? = builder.adjustments
    /**
     * The source of the CVSS data.
     */
    public val cvssSource: kotlin.String? = builder.cvssSource
    /**
     * The CVSS score.
     */
    public val score: kotlin.Double = requireNotNull(builder.score) { "A non-null value must be provided for score" }
    /**
     * The source for the CVSS score.
     */
    public val scoreSource: kotlin.String = requireNotNull(builder.scoreSource) { "A non-null value must be provided for scoreSource" }
    /**
     * The vector for the CVSS score.
     */
    public val scoringVector: kotlin.String = requireNotNull(builder.scoringVector) { "A non-null value must be provided for scoringVector" }
    /**
     * The CVSS version used in scoring.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CvssScoreDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CvssScoreDetails(")
        append("adjustments=$adjustments,")
        append("cvssSource=$cvssSource,")
        append("score=$score,")
        append("scoreSource=$scoreSource,")
        append("scoringVector=$scoringVector,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = adjustments?.hashCode() ?: 0
        result = 31 * result + (cvssSource?.hashCode() ?: 0)
        result = 31 * result + (score.hashCode())
        result = 31 * result + (scoreSource.hashCode())
        result = 31 * result + (scoringVector.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CvssScoreDetails

        if (adjustments != other.adjustments) return false
        if (cvssSource != other.cvssSource) return false
        if (score != other.score) return false
        if (scoreSource != other.scoreSource) return false
        if (scoringVector != other.scoringVector) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CvssScoreDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An object that contains details about adjustment Amazon Inspector made to the CVSS score.
         */
        public var adjustments: List<CvssScoreAdjustment>? = null
        /**
         * The source of the CVSS data.
         */
        public var cvssSource: kotlin.String? = null
        /**
         * The CVSS score.
         */
        public var score: kotlin.Double? = null
        /**
         * The source for the CVSS score.
         */
        public var scoreSource: kotlin.String? = null
        /**
         * The vector for the CVSS score.
         */
        public var scoringVector: kotlin.String? = null
        /**
         * The CVSS version used in scoring.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CvssScoreDetails) : this() {
            this.adjustments = x.adjustments
            this.cvssSource = x.cvssSource
            this.score = x.score
            this.scoreSource = x.scoreSource
            this.scoringVector = x.scoringVector
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CvssScoreDetails = CvssScoreDetails(this)

        internal fun correctErrors(): Builder {
            if (score == null) score = 0.0
            if (scoreSource == null) scoreSource = ""
            if (scoringVector == null) scoringVector = ""
            if (version == null) version = ""
            return this
        }
    }
}
