// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * A structure that identifies filter criteria for `GetCoverageStatistics`.
 */
public class CoverageFilterCriteria private constructor(builder: Builder) {
    /**
     * An array of Amazon Web Services account IDs to return coverage statistics for.
     */
    public val accountId: List<CoverageStringFilter>? = builder.accountId
    /**
     * The Amazon EC2 instance tags to filter on.
     */
    public val ec2InstanceTags: List<CoverageMapFilter>? = builder.ec2InstanceTags
    /**
     * The Amazon ECR image tags to filter on.
     */
    public val ecrImageTags: List<CoverageStringFilter>? = builder.ecrImageTags
    /**
     * The Amazon ECR repository name to filter on.
     */
    public val ecrRepositoryName: List<CoverageStringFilter>? = builder.ecrRepositoryName
    /**
     * Returns coverage statistics for AWS Lambda functions filtered by function names.
     */
    public val lambdaFunctionName: List<CoverageStringFilter>? = builder.lambdaFunctionName
    /**
     * Returns coverage statistics for AWS Lambda functions filtered by runtime.
     */
    public val lambdaFunctionRuntime: List<CoverageStringFilter>? = builder.lambdaFunctionRuntime
    /**
     * Returns coverage statistics for AWS Lambda functions filtered by tag.
     */
    public val lambdaFunctionTags: List<CoverageMapFilter>? = builder.lambdaFunctionTags
    /**
     * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities within the specified time range.
     */
    public val lastScannedAt: List<CoverageDateFilter>? = builder.lastScannedAt
    /**
     * An array of Amazon Web Services resource IDs to return coverage statistics for.
     */
    public val resourceId: List<CoverageStringFilter>? = builder.resourceId
    /**
     * An array of Amazon Web Services resource types to return coverage statistics for. The values can be `AWS_EC2_INSTANCE`, `AWS_LAMBDA_FUNCTION` or `AWS_ECR_REPOSITORY`.
     */
    public val resourceType: List<CoverageStringFilter>? = builder.resourceType
    /**
     * The scan status code to filter on. Valid values are: `ValidationException`, `InternalServerException`, `ResourceNotFoundException`, `BadRequestException`, and `ThrottlingException`.
     */
    public val scanStatusCode: List<CoverageStringFilter>? = builder.scanStatusCode
    /**
     * The scan status reason to filter on.
     */
    public val scanStatusReason: List<CoverageStringFilter>? = builder.scanStatusReason
    /**
     * An array of Amazon Inspector scan types to return coverage statistics for.
     */
    public val scanType: List<CoverageStringFilter>? = builder.scanType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CoverageFilterCriteria(")
        append("accountId=$accountId,")
        append("ec2InstanceTags=$ec2InstanceTags,")
        append("ecrImageTags=$ecrImageTags,")
        append("ecrRepositoryName=$ecrRepositoryName,")
        append("lambdaFunctionName=$lambdaFunctionName,")
        append("lambdaFunctionRuntime=$lambdaFunctionRuntime,")
        append("lambdaFunctionTags=$lambdaFunctionTags,")
        append("lastScannedAt=$lastScannedAt,")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("scanStatusCode=$scanStatusCode,")
        append("scanStatusReason=$scanStatusReason,")
        append("scanType=$scanType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (ec2InstanceTags?.hashCode() ?: 0)
        result = 31 * result + (ecrImageTags?.hashCode() ?: 0)
        result = 31 * result + (ecrRepositoryName?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionName?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionRuntime?.hashCode() ?: 0)
        result = 31 * result + (lambdaFunctionTags?.hashCode() ?: 0)
        result = 31 * result + (lastScannedAt?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (scanStatusCode?.hashCode() ?: 0)
        result = 31 * result + (scanStatusReason?.hashCode() ?: 0)
        result = 31 * result + (scanType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CoverageFilterCriteria

        if (accountId != other.accountId) return false
        if (ec2InstanceTags != other.ec2InstanceTags) return false
        if (ecrImageTags != other.ecrImageTags) return false
        if (ecrRepositoryName != other.ecrRepositoryName) return false
        if (lambdaFunctionName != other.lambdaFunctionName) return false
        if (lambdaFunctionRuntime != other.lambdaFunctionRuntime) return false
        if (lambdaFunctionTags != other.lambdaFunctionTags) return false
        if (lastScannedAt != other.lastScannedAt) return false
        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (scanStatusCode != other.scanStatusCode) return false
        if (scanStatusReason != other.scanStatusReason) return false
        if (scanType != other.scanType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of Amazon Web Services account IDs to return coverage statistics for.
         */
        public var accountId: List<CoverageStringFilter>? = null
        /**
         * The Amazon EC2 instance tags to filter on.
         */
        public var ec2InstanceTags: List<CoverageMapFilter>? = null
        /**
         * The Amazon ECR image tags to filter on.
         */
        public var ecrImageTags: List<CoverageStringFilter>? = null
        /**
         * The Amazon ECR repository name to filter on.
         */
        public var ecrRepositoryName: List<CoverageStringFilter>? = null
        /**
         * Returns coverage statistics for AWS Lambda functions filtered by function names.
         */
        public var lambdaFunctionName: List<CoverageStringFilter>? = null
        /**
         * Returns coverage statistics for AWS Lambda functions filtered by runtime.
         */
        public var lambdaFunctionRuntime: List<CoverageStringFilter>? = null
        /**
         * Returns coverage statistics for AWS Lambda functions filtered by tag.
         */
        public var lambdaFunctionTags: List<CoverageMapFilter>? = null
        /**
         * Filters Amazon Web Services resources based on whether Amazon Inspector has checked them for vulnerabilities within the specified time range.
         */
        public var lastScannedAt: List<CoverageDateFilter>? = null
        /**
         * An array of Amazon Web Services resource IDs to return coverage statistics for.
         */
        public var resourceId: List<CoverageStringFilter>? = null
        /**
         * An array of Amazon Web Services resource types to return coverage statistics for. The values can be `AWS_EC2_INSTANCE`, `AWS_LAMBDA_FUNCTION` or `AWS_ECR_REPOSITORY`.
         */
        public var resourceType: List<CoverageStringFilter>? = null
        /**
         * The scan status code to filter on. Valid values are: `ValidationException`, `InternalServerException`, `ResourceNotFoundException`, `BadRequestException`, and `ThrottlingException`.
         */
        public var scanStatusCode: List<CoverageStringFilter>? = null
        /**
         * The scan status reason to filter on.
         */
        public var scanStatusReason: List<CoverageStringFilter>? = null
        /**
         * An array of Amazon Inspector scan types to return coverage statistics for.
         */
        public var scanType: List<CoverageStringFilter>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria) : this() {
            this.accountId = x.accountId
            this.ec2InstanceTags = x.ec2InstanceTags
            this.ecrImageTags = x.ecrImageTags
            this.ecrRepositoryName = x.ecrRepositoryName
            this.lambdaFunctionName = x.lambdaFunctionName
            this.lambdaFunctionRuntime = x.lambdaFunctionRuntime
            this.lambdaFunctionTags = x.lambdaFunctionTags
            this.lastScannedAt = x.lastScannedAt
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.scanStatusCode = x.scanStatusCode
            this.scanStatusReason = x.scanStatusReason
            this.scanType = x.scanType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CoverageFilterCriteria = CoverageFilterCriteria(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
