// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * Contains information on a code snippet retrieved by Amazon Inspector from a code vulnerability finding.
 */
public class CodeSnippetResult private constructor(builder: Builder) {
    /**
     * Contains information on the retrieved code snippet.
     */
    public val codeSnippet: List<CodeLine>? = builder.codeSnippet
    /**
     * The line number of the last line of a code snippet.
     */
    public val endLine: kotlin.Int? = builder.endLine
    /**
     * The ARN of a finding that the code snippet is associated with.
     */
    public val findingArn: kotlin.String? = builder.findingArn
    /**
     * The line number of the first line of a code snippet.
     */
    public val startLine: kotlin.Int? = builder.startLine
    /**
     * Details of a suggested code fix.
     */
    public val suggestedFixes: List<SuggestedFix>? = builder.suggestedFixes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.CodeSnippetResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CodeSnippetResult(")
        append("codeSnippet=$codeSnippet,")
        append("endLine=$endLine,")
        append("findingArn=$findingArn,")
        append("startLine=$startLine,")
        append("suggestedFixes=$suggestedFixes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codeSnippet?.hashCode() ?: 0
        result = 31 * result + (endLine ?: 0)
        result = 31 * result + (findingArn?.hashCode() ?: 0)
        result = 31 * result + (startLine ?: 0)
        result = 31 * result + (suggestedFixes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CodeSnippetResult

        if (codeSnippet != other.codeSnippet) return false
        if (endLine != other.endLine) return false
        if (findingArn != other.findingArn) return false
        if (startLine != other.startLine) return false
        if (suggestedFixes != other.suggestedFixes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.CodeSnippetResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains information on the retrieved code snippet.
         */
        public var codeSnippet: List<CodeLine>? = null
        /**
         * The line number of the last line of a code snippet.
         */
        public var endLine: kotlin.Int? = null
        /**
         * The ARN of a finding that the code snippet is associated with.
         */
        public var findingArn: kotlin.String? = null
        /**
         * The line number of the first line of a code snippet.
         */
        public var startLine: kotlin.Int? = null
        /**
         * Details of a suggested code fix.
         */
        public var suggestedFixes: List<SuggestedFix>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.CodeSnippetResult) : this() {
            this.codeSnippet = x.codeSnippet
            this.endLine = x.endLine
            this.findingArn = x.findingArn
            this.startLine = x.startLine
            this.suggestedFixes = x.suggestedFixes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.CodeSnippetResult = CodeSnippetResult(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
