// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * An aggregation of information about Amazon ECR containers.
 */
public class AwsEcrContainerAggregationResponse private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID of the account that owns the container.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The architecture of the container.
     */
    public val architecture: kotlin.String? = builder.architecture
    /**
     * The SHA value of the container image.
     */
    public val imageSha: kotlin.String? = builder.imageSha
    /**
     * The container image stags.
     */
    public val imageTags: List<String>? = builder.imageTags
    /**
     * The container repository.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * The resource ID of the container.
     */
    public val resourceId: kotlin.String = requireNotNull(builder.resourceId) { "A non-null value must be provided for resourceId" }
    /**
     * The number of finding by severity.
     */
    public val severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = builder.severityCounts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.AwsEcrContainerAggregationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEcrContainerAggregationResponse(")
        append("accountId=$accountId,")
        append("architecture=$architecture,")
        append("imageSha=$imageSha,")
        append("imageTags=$imageTags,")
        append("repository=$repository,")
        append("resourceId=$resourceId,")
        append("severityCounts=$severityCounts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (imageSha?.hashCode() ?: 0)
        result = 31 * result + (imageTags?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (resourceId.hashCode())
        result = 31 * result + (severityCounts?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEcrContainerAggregationResponse

        if (accountId != other.accountId) return false
        if (architecture != other.architecture) return false
        if (imageSha != other.imageSha) return false
        if (imageTags != other.imageTags) return false
        if (repository != other.repository) return false
        if (resourceId != other.resourceId) return false
        if (severityCounts != other.severityCounts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.AwsEcrContainerAggregationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID of the account that owns the container.
         */
        public var accountId: kotlin.String? = null
        /**
         * The architecture of the container.
         */
        public var architecture: kotlin.String? = null
        /**
         * The SHA value of the container image.
         */
        public var imageSha: kotlin.String? = null
        /**
         * The container image stags.
         */
        public var imageTags: List<String>? = null
        /**
         * The container repository.
         */
        public var repository: kotlin.String? = null
        /**
         * The resource ID of the container.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The number of finding by severity.
         */
        public var severityCounts: aws.sdk.kotlin.services.inspector2.model.SeverityCounts? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.AwsEcrContainerAggregationResponse) : this() {
            this.accountId = x.accountId
            this.architecture = x.architecture
            this.imageSha = x.imageSha
            this.imageTags = x.imageTags
            this.repository = x.repository
            this.resourceId = x.resourceId
            this.severityCounts = x.severityCounts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.AwsEcrContainerAggregationResponse = AwsEcrContainerAggregationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.SeverityCounts] inside the given [block]
         */
        public fun severityCounts(block: aws.sdk.kotlin.services.inspector2.model.SeverityCounts.Builder.() -> kotlin.Unit) {
            this.severityCounts = aws.sdk.kotlin.services.inspector2.model.SeverityCounts.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resourceId == null) resourceId = ""
            return this
        }
    }
}
