// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Details of the Amazon EC2 instance involved in a finding.
 */
public class AwsEc2InstanceDetails private constructor(builder: Builder) {
    /**
     * The IAM instance profile ARN of the Amazon EC2 instance.
     */
    public val iamInstanceProfileArn: kotlin.String? = builder.iamInstanceProfileArn
    /**
     * The image ID of the Amazon EC2 instance.
     */
    public val imageId: kotlin.String? = builder.imageId
    /**
     * The IPv4 addresses of the Amazon EC2 instance.
     */
    public val ipv4Addresses: List<String>? = builder.ipv4Addresses
    /**
     * The IPv6 addresses of the Amazon EC2 instance.
     */
    public val ipv6Addresses: List<String>? = builder.ipv6Addresses
    /**
     * The name of the key pair used to launch the Amazon EC2 instance.
     */
    public val keyName: kotlin.String? = builder.keyName
    /**
     * The date and time the Amazon EC2 instance was launched at.
     */
    public val launchedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.launchedAt
    /**
     * The platform of the Amazon EC2 instance.
     */
    public val platform: kotlin.String? = builder.platform
    /**
     * The subnet ID of the Amazon EC2 instance.
     */
    public val subnetId: kotlin.String? = builder.subnetId
    /**
     * The type of the Amazon EC2 instance.
     */
    public val type: kotlin.String? = builder.type
    /**
     * The VPC ID of the Amazon EC2 instance.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.AwsEc2InstanceDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AwsEc2InstanceDetails(")
        append("iamInstanceProfileArn=$iamInstanceProfileArn,")
        append("imageId=$imageId,")
        append("ipv4Addresses=$ipv4Addresses,")
        append("ipv6Addresses=$ipv6Addresses,")
        append("keyName=$keyName,")
        append("launchedAt=$launchedAt,")
        append("platform=$platform,")
        append("subnetId=$subnetId,")
        append("type=$type,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = iamInstanceProfileArn?.hashCode() ?: 0
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (ipv4Addresses?.hashCode() ?: 0)
        result = 31 * result + (ipv6Addresses?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchedAt?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AwsEc2InstanceDetails

        if (iamInstanceProfileArn != other.iamInstanceProfileArn) return false
        if (imageId != other.imageId) return false
        if (ipv4Addresses != other.ipv4Addresses) return false
        if (ipv6Addresses != other.ipv6Addresses) return false
        if (keyName != other.keyName) return false
        if (launchedAt != other.launchedAt) return false
        if (platform != other.platform) return false
        if (subnetId != other.subnetId) return false
        if (type != other.type) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.AwsEc2InstanceDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The IAM instance profile ARN of the Amazon EC2 instance.
         */
        public var iamInstanceProfileArn: kotlin.String? = null
        /**
         * The image ID of the Amazon EC2 instance.
         */
        public var imageId: kotlin.String? = null
        /**
         * The IPv4 addresses of the Amazon EC2 instance.
         */
        public var ipv4Addresses: List<String>? = null
        /**
         * The IPv6 addresses of the Amazon EC2 instance.
         */
        public var ipv6Addresses: List<String>? = null
        /**
         * The name of the key pair used to launch the Amazon EC2 instance.
         */
        public var keyName: kotlin.String? = null
        /**
         * The date and time the Amazon EC2 instance was launched at.
         */
        public var launchedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The platform of the Amazon EC2 instance.
         */
        public var platform: kotlin.String? = null
        /**
         * The subnet ID of the Amazon EC2 instance.
         */
        public var subnetId: kotlin.String? = null
        /**
         * The type of the Amazon EC2 instance.
         */
        public var type: kotlin.String? = null
        /**
         * The VPC ID of the Amazon EC2 instance.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.AwsEc2InstanceDetails) : this() {
            this.iamInstanceProfileArn = x.iamInstanceProfileArn
            this.imageId = x.imageId
            this.ipv4Addresses = x.ipv4Addresses
            this.ipv6Addresses = x.ipv6Addresses
            this.keyName = x.keyName
            this.launchedAt = x.launchedAt
            this.platform = x.platform
            this.subnetId = x.subnetId
            this.type = x.type
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.AwsEc2InstanceDetails = AwsEc2InstanceDetails(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
