// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * An object with details the status of an Amazon Web Services account within your Amazon Inspector environment.
 */
public class AccountState private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * An object detailing which resources Amazon Inspector is enabled to scan for the account.
     */
    public val resourceState: aws.sdk.kotlin.services.inspector2.model.ResourceState? = builder.resourceState
    /**
     * An object detailing the status of Amazon Inspector for the account.
     */
    public val state: aws.sdk.kotlin.services.inspector2.model.State? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.AccountState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountState(")
        append("accountId=$accountId,")
        append("resourceState=$resourceState,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (resourceState?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountState

        if (accountId != other.accountId) return false
        if (resourceState != other.resourceState) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.AccountState = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services account ID.
         */
        public var accountId: kotlin.String? = null
        /**
         * An object detailing which resources Amazon Inspector is enabled to scan for the account.
         */
        public var resourceState: aws.sdk.kotlin.services.inspector2.model.ResourceState? = null
        /**
         * An object detailing the status of Amazon Inspector for the account.
         */
        public var state: aws.sdk.kotlin.services.inspector2.model.State? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.AccountState) : this() {
            this.accountId = x.accountId
            this.resourceState = x.resourceState
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.AccountState = AccountState(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ResourceState] inside the given [block]
         */
        public fun resourceState(block: aws.sdk.kotlin.services.inspector2.model.ResourceState.Builder.() -> kotlin.Unit) {
            this.resourceState = aws.sdk.kotlin.services.inspector2.model.ResourceState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.State] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.inspector2.model.State.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.inspector2.model.State.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            return this
        }
    }
}
