// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector2.model



/**
 * An Amazon Web Services account within your environment that Amazon Inspector has been enabled for.
 */
public class Account private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account.
     */
    public val accountId: kotlin.String = requireNotNull(builder.accountId) { "A non-null value must be provided for accountId" }
    /**
     * Details of the status of Amazon Inspector scans by resource type.
     */
    public val resourceStatus: aws.sdk.kotlin.services.inspector2.model.ResourceStatus? = builder.resourceStatus
    /**
     * The status of Amazon Inspector for the account.
     */
    public val status: aws.sdk.kotlin.services.inspector2.model.Status = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector2.model.Account = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Account(")
        append("accountId=$accountId,")
        append("resourceStatus=$resourceStatus,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId.hashCode()
        result = 31 * result + (resourceStatus?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Account

        if (accountId != other.accountId) return false
        if (resourceStatus != other.resourceStatus) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector2.model.Account = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the Amazon Web Services account.
         */
        public var accountId: kotlin.String? = null
        /**
         * Details of the status of Amazon Inspector scans by resource type.
         */
        public var resourceStatus: aws.sdk.kotlin.services.inspector2.model.ResourceStatus? = null
        /**
         * The status of Amazon Inspector for the account.
         */
        public var status: aws.sdk.kotlin.services.inspector2.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector2.model.Account) : this() {
            this.accountId = x.accountId
            this.resourceStatus = x.resourceStatus
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector2.model.Account = Account(this)

        /**
         * construct an [aws.sdk.kotlin.services.inspector2.model.ResourceStatus] inside the given [block]
         */
        public fun resourceStatus(block: aws.sdk.kotlin.services.inspector2.model.ResourceStatus.Builder.() -> kotlin.Unit) {
            this.resourceStatus = aws.sdk.kotlin.services.inspector2.model.ResourceStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountId == null) accountId = ""
            if (status == null) status = Status.SdkUnknown("no value provided")
            return this
        }
    }
}
