// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.interceptors.BusinessMetricsInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.inspector.auth.InspectorAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.inspector.auth.InspectorIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.inspector.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.inspector.model.*
import aws.sdk.kotlin.services.inspector.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultInspectorClient(override val config: InspectorClient.Config) : InspectorClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = InspectorIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "inspector")
        }
        toMap()
    }
    private val authSchemeAdapter = InspectorAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.inspector"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.AddAttributesToFindings.sample
     */
    override suspend fun addAttributesToFindings(input: AddAttributesToFindingsRequest): AddAttributesToFindingsResponse {
        val op = SdkHttpOperation.build<AddAttributesToFindingsRequest, AddAttributesToFindingsResponse> {
            serializeWith = AddAttributesToFindingsOperationSerializer()
            deserializeWith = AddAttributesToFindingsOperationDeserializer()
            operationName = "AddAttributesToFindings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments. You can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent agents per AWS account. For more information, see [ Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.CreateAssessmentTarget.sample
     */
    override suspend fun createAssessmentTarget(input: CreateAssessmentTargetRequest): CreateAssessmentTargetResponse {
        val op = SdkHttpOperation.build<CreateAssessmentTargetRequest, CreateAssessmentTargetResponse> {
            serializeWith = CreateAssessmentTargetOperationSerializer()
            deserializeWith = CreateAssessmentTargetOperationDeserializer()
            operationName = "CreateAssessmentTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates an assessment template for the assessment target that is specified by the ARN of the assessment target. If the [service-linked role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html) isn’t already registered, this action also creates and registers a service-linked role to grant Amazon Inspector access to AWS Services needed to perform security assessments.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.CreateAssessmentTemplate.sample
     */
    override suspend fun createAssessmentTemplate(input: CreateAssessmentTemplateRequest): CreateAssessmentTemplateResponse {
        val op = SdkHttpOperation.build<CreateAssessmentTemplateRequest, CreateAssessmentTemplateResponse> {
            serializeWith = CreateAssessmentTemplateOperationSerializer()
            deserializeWith = CreateAssessmentTemplateOperationDeserializer()
            operationName = "CreateAssessmentTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the generation of an exclusions preview for the specified assessment template. The exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can detect before it runs the assessment.
     */
    override suspend fun createExclusionsPreview(input: CreateExclusionsPreviewRequest): CreateExclusionsPreviewResponse {
        val op = SdkHttpOperation.build<CreateExclusionsPreviewRequest, CreateExclusionsPreviewResponse> {
            serializeWith = CreateExclusionsPreviewOperationSerializer()
            deserializeWith = CreateExclusionsPreviewOperationDeserializer()
            operationName = "CreateExclusionsPreview"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target. The created resource group is then used to create an Amazon Inspector assessment target. For more information, see CreateAssessmentTarget.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.CreateResourceGroup.sample
     */
    override suspend fun createResourceGroup(input: CreateResourceGroupRequest): CreateResourceGroupResponse {
        val op = SdkHttpOperation.build<CreateResourceGroupRequest, CreateResourceGroupResponse> {
            serializeWith = CreateResourceGroupOperationSerializer()
            deserializeWith = CreateResourceGroupOperationDeserializer()
            operationName = "CreateResourceGroup"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the assessment run that is specified by the ARN of the assessment run.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.DeleteAssessmentRun.sample
     */
    override suspend fun deleteAssessmentRun(input: DeleteAssessmentRunRequest): DeleteAssessmentRunResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentRunRequest, DeleteAssessmentRunResponse> {
            serializeWith = DeleteAssessmentRunOperationSerializer()
            deserializeWith = DeleteAssessmentRunOperationDeserializer()
            operationName = "DeleteAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the assessment target that is specified by the ARN of the assessment target.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.DeleteAssessmentTarget.sample
     */
    override suspend fun deleteAssessmentTarget(input: DeleteAssessmentTargetRequest): DeleteAssessmentTargetResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentTargetRequest, DeleteAssessmentTargetResponse> {
            serializeWith = DeleteAssessmentTargetOperationSerializer()
            deserializeWith = DeleteAssessmentTargetOperationDeserializer()
            operationName = "DeleteAssessmentTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the assessment template that is specified by the ARN of the assessment template.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.DeleteAssessmentTemplate.sample
     */
    override suspend fun deleteAssessmentTemplate(input: DeleteAssessmentTemplateRequest): DeleteAssessmentTemplateResponse {
        val op = SdkHttpOperation.build<DeleteAssessmentTemplateRequest, DeleteAssessmentTemplateResponse> {
            serializeWith = DeleteAssessmentTemplateOperationSerializer()
            deserializeWith = DeleteAssessmentTemplateOperationDeserializer()
            operationName = "DeleteAssessmentTemplate"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the assessment runs that are specified by the ARNs of the assessment runs.
     */
    override suspend fun describeAssessmentRuns(input: DescribeAssessmentRunsRequest): DescribeAssessmentRunsResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentRunsRequest, DescribeAssessmentRunsResponse> {
            serializeWith = DescribeAssessmentRunsOperationSerializer()
            deserializeWith = DescribeAssessmentRunsOperationDeserializer()
            operationName = "DescribeAssessmentRuns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the assessment targets that are specified by the ARNs of the assessment targets.
     */
    override suspend fun describeAssessmentTargets(input: DescribeAssessmentTargetsRequest): DescribeAssessmentTargetsResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentTargetsRequest, DescribeAssessmentTargetsResponse> {
            serializeWith = DescribeAssessmentTargetsOperationSerializer()
            deserializeWith = DescribeAssessmentTargetsOperationDeserializer()
            operationName = "DescribeAssessmentTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the assessment templates that are specified by the ARNs of the assessment templates.
     */
    override suspend fun describeAssessmentTemplates(input: DescribeAssessmentTemplatesRequest): DescribeAssessmentTemplatesResponse {
        val op = SdkHttpOperation.build<DescribeAssessmentTemplatesRequest, DescribeAssessmentTemplatesResponse> {
            serializeWith = DescribeAssessmentTemplatesOperationSerializer()
            deserializeWith = DescribeAssessmentTemplatesOperationDeserializer()
            operationName = "DescribeAssessmentTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the IAM role that enables Amazon Inspector to access your AWS account.
     */
    override suspend fun describeCrossAccountAccessRole(input: DescribeCrossAccountAccessRoleRequest): DescribeCrossAccountAccessRoleResponse {
        val op = SdkHttpOperation.build<DescribeCrossAccountAccessRoleRequest, DescribeCrossAccountAccessRoleResponse> {
            serializeWith = DescribeCrossAccountAccessRoleOperationSerializer()
            deserializeWith = DescribeCrossAccountAccessRoleOperationDeserializer()
            operationName = "DescribeCrossAccountAccessRole"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the exclusions that are specified by the exclusions' ARNs.
     */
    override suspend fun describeExclusions(input: DescribeExclusionsRequest): DescribeExclusionsResponse {
        val op = SdkHttpOperation.build<DescribeExclusionsRequest, DescribeExclusionsResponse> {
            serializeWith = DescribeExclusionsOperationSerializer()
            deserializeWith = DescribeExclusionsOperationDeserializer()
            operationName = "DescribeExclusions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the findings that are specified by the ARNs of the findings.
     */
    override suspend fun describeFindings(input: DescribeFindingsRequest): DescribeFindingsResponse {
        val op = SdkHttpOperation.build<DescribeFindingsRequest, DescribeFindingsResponse> {
            serializeWith = DescribeFindingsOperationSerializer()
            deserializeWith = DescribeFindingsOperationDeserializer()
            operationName = "DescribeFindings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the resource groups that are specified by the ARNs of the resource groups.
     */
    override suspend fun describeResourceGroups(input: DescribeResourceGroupsRequest): DescribeResourceGroupsResponse {
        val op = SdkHttpOperation.build<DescribeResourceGroupsRequest, DescribeResourceGroupsResponse> {
            serializeWith = DescribeResourceGroupsOperationSerializer()
            deserializeWith = DescribeResourceGroupsOperationDeserializer()
            operationName = "DescribeResourceGroups"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes the rules packages that are specified by the ARNs of the rules packages.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.DescribeRulesPackages.sample
     */
    override suspend fun describeRulesPackages(input: DescribeRulesPackagesRequest): DescribeRulesPackagesResponse {
        val op = SdkHttpOperation.build<DescribeRulesPackagesRequest, DescribeRulesPackagesResponse> {
            serializeWith = DescribeRulesPackagesOperationSerializer()
            deserializeWith = DescribeRulesPackagesOperationDeserializer()
            operationName = "DescribeRulesPackages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Produces an assessment report that includes detailed and comprehensive results of a specified assessment run.
     */
    override suspend fun getAssessmentReport(input: GetAssessmentReportRequest): GetAssessmentReportResponse {
        val op = SdkHttpOperation.build<GetAssessmentReportRequest, GetAssessmentReportResponse> {
            serializeWith = GetAssessmentReportOperationSerializer()
            deserializeWith = GetAssessmentReportOperationDeserializer()
            operationName = "GetAssessmentReport"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token. You can obtain the preview token by running the CreateExclusionsPreview API.
     */
    override suspend fun getExclusionsPreview(input: GetExclusionsPreviewRequest): GetExclusionsPreviewResponse {
        val op = SdkHttpOperation.build<GetExclusionsPreviewRequest, GetExclusionsPreviewResponse> {
            serializeWith = GetExclusionsPreviewOperationSerializer()
            deserializeWith = GetExclusionsPreviewOperationDeserializer()
            operationName = "GetExclusionsPreview"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Information about the data that is collected for the specified assessment run.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.GetTelemetryMetadata.sample
     */
    override suspend fun getTelemetryMetadata(input: GetTelemetryMetadataRequest): GetTelemetryMetadataResponse {
        val op = SdkHttpOperation.build<GetTelemetryMetadataRequest, GetTelemetryMetadataResponse> {
            serializeWith = GetTelemetryMetadataOperationSerializer()
            deserializeWith = GetTelemetryMetadataOperationDeserializer()
            operationName = "GetTelemetryMetadata"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListAssessmentRunAgents.sample
     */
    override suspend fun listAssessmentRunAgents(input: ListAssessmentRunAgentsRequest): ListAssessmentRunAgentsResponse {
        val op = SdkHttpOperation.build<ListAssessmentRunAgentsRequest, ListAssessmentRunAgentsResponse> {
            serializeWith = ListAssessmentRunAgentsOperationSerializer()
            deserializeWith = ListAssessmentRunAgentsOperationDeserializer()
            operationName = "ListAssessmentRunAgents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListAssessmentRuns.sample
     */
    override suspend fun listAssessmentRuns(input: ListAssessmentRunsRequest): ListAssessmentRunsResponse {
        val op = SdkHttpOperation.build<ListAssessmentRunsRequest, ListAssessmentRunsResponse> {
            serializeWith = ListAssessmentRunsOperationSerializer()
            deserializeWith = ListAssessmentRunsOperationDeserializer()
            operationName = "ListAssessmentRuns"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the ARNs of the assessment targets within this AWS account. For more information about assessment targets, see [Amazon Inspector Assessment Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListAssessmentTargets.sample
     */
    override suspend fun listAssessmentTargets(input: ListAssessmentTargetsRequest): ListAssessmentTargetsResponse {
        val op = SdkHttpOperation.build<ListAssessmentTargetsRequest, ListAssessmentTargetsResponse> {
            serializeWith = ListAssessmentTargetsOperationSerializer()
            deserializeWith = ListAssessmentTargetsOperationDeserializer()
            operationName = "ListAssessmentTargets"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListAssessmentTemplates.sample
     */
    override suspend fun listAssessmentTemplates(input: ListAssessmentTemplatesRequest): ListAssessmentTemplatesResponse {
        val op = SdkHttpOperation.build<ListAssessmentTemplatesRequest, ListAssessmentTemplatesResponse> {
            serializeWith = ListAssessmentTemplatesOperationSerializer()
            deserializeWith = ListAssessmentTemplatesOperationDeserializer()
            operationName = "ListAssessmentTemplates"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template. For more information, see SubscribeToEvent and UnsubscribeFromEvent.
     */
    override suspend fun listEventSubscriptions(input: ListEventSubscriptionsRequest): ListEventSubscriptionsResponse {
        val op = SdkHttpOperation.build<ListEventSubscriptionsRequest, ListEventSubscriptionsResponse> {
            serializeWith = ListEventSubscriptionsOperationSerializer()
            deserializeWith = ListEventSubscriptionsOperationDeserializer()
            operationName = "ListEventSubscriptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * List exclusions that are generated by the assessment run.
     */
    override suspend fun listExclusions(input: ListExclusionsRequest): ListExclusionsResponse {
        val op = SdkHttpOperation.build<ListExclusionsRequest, ListExclusionsResponse> {
            serializeWith = ListExclusionsOperationSerializer()
            deserializeWith = ListExclusionsOperationDeserializer()
            operationName = "ListExclusions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListFindings.sample
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializeWith = ListFindingsOperationSerializer()
            deserializeWith = ListFindingsOperationDeserializer()
            operationName = "ListFindings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all available Amazon Inspector rules packages.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListRulesPackages.sample
     */
    override suspend fun listRulesPackages(input: ListRulesPackagesRequest): ListRulesPackagesResponse {
        val op = SdkHttpOperation.build<ListRulesPackagesRequest, ListRulesPackagesResponse> {
            serializeWith = ListRulesPackagesOperationSerializer()
            deserializeWith = ListRulesPackagesOperationDeserializer()
            operationName = "ListRulesPackages"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all tags associated with an assessment template.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.ListTagsForResource.sample
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializeWith = ListTagsForResourceOperationSerializer()
            deserializeWith = ListTagsForResourceOperationDeserializer()
            operationName = "ListTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Previews the agents installed on the EC2 instances that are part of the specified assessment target.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.PreviewAgents.sample
     */
    override suspend fun previewAgents(input: PreviewAgentsRequest): PreviewAgentsResponse {
        val op = SdkHttpOperation.build<PreviewAgentsRequest, PreviewAgentsResponse> {
            serializeWith = PreviewAgentsOperationSerializer()
            deserializeWith = PreviewAgentsOperationDeserializer()
            operationName = "PreviewAgents"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.RegisterCrossAccountAccessRole.sample
     */
    override suspend fun registerCrossAccountAccessRole(input: RegisterCrossAccountAccessRoleRequest): RegisterCrossAccountAccessRoleResponse {
        val op = SdkHttpOperation.build<RegisterCrossAccountAccessRoleRequest, RegisterCrossAccountAccessRoleResponse> {
            serializeWith = RegisterCrossAccountAccessRoleOperationSerializer()
            deserializeWith = RegisterCrossAccountAccessRoleOperationDeserializer()
            operationName = "RegisterCrossAccountAccessRole"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.RemoveAttributesFromFindings.sample
     */
    override suspend fun removeAttributesFromFindings(input: RemoveAttributesFromFindingsRequest): RemoveAttributesFromFindingsResponse {
        val op = SdkHttpOperation.build<RemoveAttributesFromFindingsRequest, RemoveAttributesFromFindingsResponse> {
            serializeWith = RemoveAttributesFromFindingsOperationSerializer()
            deserializeWith = RemoveAttributesFromFindingsOperationDeserializer()
            operationName = "RemoveAttributesFromFindings"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.SetTagsForResource.sample
     */
    override suspend fun setTagsForResource(input: SetTagsForResourceRequest): SetTagsForResourceResponse {
        val op = SdkHttpOperation.build<SetTagsForResourceRequest, SetTagsForResourceResponse> {
            serializeWith = SetTagsForResourceOperationSerializer()
            deserializeWith = SetTagsForResourceOperationDeserializer()
            operationName = "SetTagsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Starts the assessment run specified by the ARN of the assessment template. For this API to function properly, you must not exceed the limit of running up to 500 concurrent agents per AWS account.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.StartAssessmentRun.sample
     */
    override suspend fun startAssessmentRun(input: StartAssessmentRunRequest): StartAssessmentRunResponse {
        val op = SdkHttpOperation.build<StartAssessmentRunRequest, StartAssessmentRunResponse> {
            serializeWith = StartAssessmentRunOperationSerializer()
            deserializeWith = StartAssessmentRunOperationDeserializer()
            operationName = "StartAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops the assessment run that is specified by the ARN of the assessment run.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.StopAssessmentRun.sample
     */
    override suspend fun stopAssessmentRun(input: StopAssessmentRunRequest): StopAssessmentRunResponse {
        val op = SdkHttpOperation.build<StopAssessmentRunRequest, StopAssessmentRunResponse> {
            serializeWith = StopAssessmentRunOperationSerializer()
            deserializeWith = StopAssessmentRunOperationDeserializer()
            operationName = "StopAssessmentRun"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.SubscribeToEvent.sample
     */
    override suspend fun subscribeToEvent(input: SubscribeToEventRequest): SubscribeToEventResponse {
        val op = SdkHttpOperation.build<SubscribeToEventRequest, SubscribeToEventResponse> {
            serializeWith = SubscribeToEventOperationSerializer()
            deserializeWith = SubscribeToEventOperationDeserializer()
            operationName = "SubscribeToEvent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.UnsubscribeFromEvent.sample
     */
    override suspend fun unsubscribeFromEvent(input: UnsubscribeFromEventRequest): UnsubscribeFromEventResponse {
        val op = SdkHttpOperation.build<UnsubscribeFromEventRequest, UnsubscribeFromEventResponse> {
            serializeWith = UnsubscribeFromEventOperationSerializer()
            deserializeWith = UnsubscribeFromEventOperationDeserializer()
            operationName = "UnsubscribeFromEvent"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the assessment target that is specified by the ARN of the assessment target.
     *
     * If resourceGroupArn is not specified, all EC2 instances in the current AWS account and region are included in the assessment target.
     *
     * @sample aws.sdk.kotlin.services.inspector.samples.UpdateAssessmentTarget.sample
     */
    override suspend fun updateAssessmentTarget(input: UpdateAssessmentTargetRequest): UpdateAssessmentTargetResponse {
        val op = SdkHttpOperation.build<UpdateAssessmentTargetRequest, UpdateAssessmentTargetResponse> {
            serializeWith = UpdateAssessmentTargetOperationSerializer()
            deserializeWith = UpdateAssessmentTargetOperationDeserializer()
            operationName = "UpdateAssessmentTarget"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.interceptors.add(BusinessMetricsInterceptor())
        op.install(AwsJsonProtocol("InspectorService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "inspector")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
