// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about a resource group. The resource group defines a set of tags that, when queried, identify the AWS resources that make up the assessment target. This data type is used as the response element in the DescribeResourceGroups action.
 */
public class ResourceGroup private constructor(builder: Builder) {
    /**
     * The ARN of the resource group.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The time at which resource group is created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The tags (key and value pairs) of the resource group. This data type property is used in the CreateResourceGroup action.
     */
    public val tags: List<ResourceGroupTag> = requireNotNull(builder.tags) { "A non-null value must be provided for tags" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.ResourceGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceGroup(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (tags.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceGroup

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.ResourceGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the resource group.
         */
        public var arn: kotlin.String? = null
        /**
         * The time at which resource group is created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The tags (key and value pairs) of the resource group. This data type property is used in the CreateResourceGroup action.
         */
        public var tags: List<ResourceGroupTag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.ResourceGroup) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.ResourceGroup = ResourceGroup(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (tags == null) tags = emptyList()
            return this
        }
    }
}
