// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.inspector.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an Amazon Inspector assessment template. This data type is used as the response element in the DescribeAssessmentTemplates action.
 */
public class AssessmentTemplate private constructor(builder: Builder) {
    /**
     * The ARN of the assessment template.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The number of existing assessment runs associated with this assessment template. This value can be zero or a positive integer.
     */
    public val assessmentRunCount: kotlin.Int = requireNotNull(builder.assessmentRunCount) { "A non-null value must be provided for assessmentRunCount" }
    /**
     * The ARN of the assessment target that corresponds to this assessment template.
     */
    public val assessmentTargetArn: kotlin.String = requireNotNull(builder.assessmentTargetArn) { "A non-null value must be provided for assessmentTargetArn" }
    /**
     * The time at which the assessment template is created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The duration in seconds specified for this assessment template. The default value is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).
     */
    public val durationInSeconds: kotlin.Int = requireNotNull(builder.durationInSeconds) { "A non-null value must be provided for durationInSeconds" }
    /**
     * The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment template. This value exists only when the value of assessmentRunCount is greaterpa than zero.
     */
    public val lastAssessmentRunArn: kotlin.String? = builder.lastAssessmentRunArn
    /**
     * The name of the assessment template.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The rules packages that are specified for this assessment template.
     */
    public val rulesPackageArns: List<String> = requireNotNull(builder.rulesPackageArns) { "A non-null value must be provided for rulesPackageArns" }
    /**
     * The user-defined attributes that are assigned to every generated finding from the assessment run that uses this assessment template.
     */
    public val userAttributesForFindings: List<Attribute> = requireNotNull(builder.userAttributesForFindings) { "A non-null value must be provided for userAttributesForFindings" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.inspector.model.AssessmentTemplate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentTemplate(")
        append("arn=$arn,")
        append("assessmentRunCount=$assessmentRunCount,")
        append("assessmentTargetArn=$assessmentTargetArn,")
        append("createdAt=$createdAt,")
        append("durationInSeconds=$durationInSeconds,")
        append("lastAssessmentRunArn=$lastAssessmentRunArn,")
        append("name=$name,")
        append("rulesPackageArns=$rulesPackageArns,")
        append("userAttributesForFindings=$userAttributesForFindings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assessmentRunCount)
        result = 31 * result + (assessmentTargetArn.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (durationInSeconds)
        result = 31 * result + (lastAssessmentRunArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (rulesPackageArns.hashCode())
        result = 31 * result + (userAttributesForFindings.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentTemplate

        if (arn != other.arn) return false
        if (assessmentRunCount != other.assessmentRunCount) return false
        if (assessmentTargetArn != other.assessmentTargetArn) return false
        if (createdAt != other.createdAt) return false
        if (durationInSeconds != other.durationInSeconds) return false
        if (lastAssessmentRunArn != other.lastAssessmentRunArn) return false
        if (name != other.name) return false
        if (rulesPackageArns != other.rulesPackageArns) return false
        if (userAttributesForFindings != other.userAttributesForFindings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.inspector.model.AssessmentTemplate = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the assessment template.
         */
        public var arn: kotlin.String? = null
        /**
         * The number of existing assessment runs associated with this assessment template. This value can be zero or a positive integer.
         */
        public var assessmentRunCount: kotlin.Int? = null
        /**
         * The ARN of the assessment target that corresponds to this assessment template.
         */
        public var assessmentTargetArn: kotlin.String? = null
        /**
         * The time at which the assessment template is created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The duration in seconds specified for this assessment template. The default value is 3600 seconds (one hour). The maximum value is 86400 seconds (one day).
         */
        public var durationInSeconds: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) of the most recent assessment run associated with this assessment template. This value exists only when the value of assessmentRunCount is greaterpa than zero.
         */
        public var lastAssessmentRunArn: kotlin.String? = null
        /**
         * The name of the assessment template.
         */
        public var name: kotlin.String? = null
        /**
         * The rules packages that are specified for this assessment template.
         */
        public var rulesPackageArns: List<String>? = null
        /**
         * The user-defined attributes that are assigned to every generated finding from the assessment run that uses this assessment template.
         */
        public var userAttributesForFindings: List<Attribute>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.inspector.model.AssessmentTemplate) : this() {
            this.arn = x.arn
            this.assessmentRunCount = x.assessmentRunCount
            this.assessmentTargetArn = x.assessmentTargetArn
            this.createdAt = x.createdAt
            this.durationInSeconds = x.durationInSeconds
            this.lastAssessmentRunArn = x.lastAssessmentRunArn
            this.name = x.name
            this.rulesPackageArns = x.rulesPackageArns
            this.userAttributesForFindings = x.userAttributesForFindings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.inspector.model.AssessmentTemplate = AssessmentTemplate(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (assessmentRunCount == null) assessmentRunCount = 0
            if (assessmentTargetArn == null) assessmentTargetArn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (durationInSeconds == null) durationInSeconds = 0
            if (name == null) name = ""
            if (rulesPackageArns == null) rulesPackageArns = emptyList()
            if (userAttributesForFindings == null) userAttributesForFindings = emptyList()
            return this
        }
    }
}
